/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumerBase;
import org.apache.flink.streaming.connectors.kafka.config.StartupMode;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import org.junit.Assert;
import org.junit.Test;

public class KafkaConsumerPartitionAssignmentTest {
    @Test
    public void testPartitionsEqualConsumers() {
        try {
            List<KafkaTopicPartition> inPartitions = Arrays.asList(new KafkaTopicPartition("test-topic", 4), new KafkaTopicPartition("test-topic", 52), new KafkaTopicPartition("test-topic", 17), new KafkaTopicPartition("test-topic", 1));
            for (int i = 0; i < inPartitions.size(); ++i) {
                HashMap subscribedPartitionsToStartOffsets = new HashMap();
                FlinkKafkaConsumerBase.initializeSubscribedPartitionsToStartOffsets(subscribedPartitionsToStartOffsets, inPartitions, (int)i, (int)inPartitions.size(), (StartupMode)StartupMode.GROUP_OFFSETS, null);
                ArrayList subscribedPartitions = new ArrayList(subscribedPartitionsToStartOffsets.keySet());
                Assert.assertEquals((long)1L, (long)subscribedPartitions.size());
                Assert.assertTrue((boolean)this.contains(inPartitions, ((KafkaTopicPartition)subscribedPartitions.get(0)).getPartition()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testMultiplePartitionsPerConsumers() {
        try {
            int[] partitionIDs = new int[]{4, 52, 17, 1, 2, 3, 89, 42, 31, 127, 14};
            ArrayList<KafkaTopicPartition> partitions = new ArrayList<KafkaTopicPartition>();
            HashSet<KafkaTopicPartition> allPartitions = new HashSet<KafkaTopicPartition>();
            for (int p : partitionIDs) {
                KafkaTopicPartition part = new KafkaTopicPartition("test-topic", p);
                partitions.add(part);
                allPartitions.add(part);
            }
            int numConsumers = 3;
            int minPartitionsPerConsumer = partitions.size() / 3;
            int maxPartitionsPerConsumer = partitions.size() / 3 + 1;
            for (int i = 0; i < 3; ++i) {
                HashMap subscribedPartitionsToStartOffsets = new HashMap();
                FlinkKafkaConsumerBase.initializeSubscribedPartitionsToStartOffsets(subscribedPartitionsToStartOffsets, partitions, (int)i, (int)3, (StartupMode)StartupMode.GROUP_OFFSETS, null);
                ArrayList subscribedPartitions = new ArrayList(subscribedPartitionsToStartOffsets.keySet());
                Assert.assertTrue((subscribedPartitions.size() >= minPartitionsPerConsumer ? 1 : 0) != 0);
                Assert.assertTrue((subscribedPartitions.size() <= maxPartitionsPerConsumer ? 1 : 0) != 0);
                for (KafkaTopicPartition p : subscribedPartitions) {
                    Assert.assertTrue((boolean)allPartitions.remove(p));
                }
            }
            Assert.assertTrue((boolean)allPartitions.isEmpty());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPartitionsFewerThanConsumers() {
        try {
            List<KafkaTopicPartition> inPartitions = Arrays.asList(new KafkaTopicPartition("test-topic", 4), new KafkaTopicPartition("test-topic", 52), new KafkaTopicPartition("test-topic", 17), new KafkaTopicPartition("test-topic", 1));
            HashSet<KafkaTopicPartition> allPartitions = new HashSet<KafkaTopicPartition>();
            allPartitions.addAll(inPartitions);
            int numConsumers = 2 * inPartitions.size() + 3;
            for (int i = 0; i < numConsumers; ++i) {
                HashMap subscribedPartitionsToStartOffsets = new HashMap();
                FlinkKafkaConsumerBase.initializeSubscribedPartitionsToStartOffsets(subscribedPartitionsToStartOffsets, inPartitions, (int)i, (int)numConsumers, (StartupMode)StartupMode.GROUP_OFFSETS, null);
                ArrayList subscribedPartitions = new ArrayList(subscribedPartitionsToStartOffsets.keySet());
                Assert.assertTrue((subscribedPartitions.size() <= 1 ? 1 : 0) != 0);
                for (KafkaTopicPartition p : subscribedPartitions) {
                    Assert.assertTrue((boolean)allPartitions.remove(p));
                }
            }
            Assert.assertTrue((boolean)allPartitions.isEmpty());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAssignEmptyPartitions() {
        try {
            ArrayList ep = new ArrayList();
            HashMap subscribedPartitionsToStartOffsets = new HashMap();
            FlinkKafkaConsumerBase.initializeSubscribedPartitionsToStartOffsets(subscribedPartitionsToStartOffsets, ep, (int)2, (int)4, (StartupMode)StartupMode.GROUP_OFFSETS, null);
            Assert.assertTrue((boolean)subscribedPartitionsToStartOffsets.entrySet().isEmpty());
            subscribedPartitionsToStartOffsets = new HashMap();
            FlinkKafkaConsumerBase.initializeSubscribedPartitionsToStartOffsets(subscribedPartitionsToStartOffsets, ep, (int)0, (int)1, (StartupMode)StartupMode.GROUP_OFFSETS, null);
            Assert.assertTrue((boolean)subscribedPartitionsToStartOffsets.entrySet().isEmpty());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGrowingPartitionsRemainsStable() {
        try {
            int[] newPartitionIDs = new int[]{4, 52, 17, 1, 2, 3, 89, 42, 31, 127, 14};
            ArrayList<KafkaTopicPartition> newPartitions = new ArrayList<KafkaTopicPartition>();
            for (int p : newPartitionIDs) {
                KafkaTopicPartition part = new KafkaTopicPartition("test-topic", p);
                newPartitions.add(part);
            }
            List initialPartitions = newPartitions.subList(0, 7);
            HashSet allNewPartitions = new HashSet(newPartitions);
            HashSet allInitialPartitions = new HashSet(initialPartitions);
            int numConsumers = 3;
            int minInitialPartitionsPerConsumer = initialPartitions.size() / 3;
            int maxInitialPartitionsPerConsumer = initialPartitions.size() / 3 + 1;
            int minNewPartitionsPerConsumer = newPartitions.size() / 3;
            int maxNewPartitionsPerConsumer = newPartitions.size() / 3 + 1;
            HashMap subscribedPartitionsToStartOffsets1 = new HashMap();
            HashMap subscribedPartitionsToStartOffsets2 = new HashMap();
            HashMap subscribedPartitionsToStartOffsets3 = new HashMap();
            FlinkKafkaConsumerBase.initializeSubscribedPartitionsToStartOffsets(subscribedPartitionsToStartOffsets1, initialPartitions, (int)0, (int)3, (StartupMode)StartupMode.GROUP_OFFSETS, null);
            FlinkKafkaConsumerBase.initializeSubscribedPartitionsToStartOffsets(subscribedPartitionsToStartOffsets2, initialPartitions, (int)1, (int)3, (StartupMode)StartupMode.GROUP_OFFSETS, null);
            FlinkKafkaConsumerBase.initializeSubscribedPartitionsToStartOffsets(subscribedPartitionsToStartOffsets3, initialPartitions, (int)2, (int)3, (StartupMode)StartupMode.GROUP_OFFSETS, null);
            ArrayList subscribedPartitions1 = new ArrayList(subscribedPartitionsToStartOffsets1.keySet());
            ArrayList subscribedPartitions2 = new ArrayList(subscribedPartitionsToStartOffsets2.keySet());
            ArrayList subscribedPartitions3 = new ArrayList(subscribedPartitionsToStartOffsets3.keySet());
            Assert.assertTrue((subscribedPartitions1.size() >= minInitialPartitionsPerConsumer ? 1 : 0) != 0);
            Assert.assertTrue((subscribedPartitions1.size() <= maxInitialPartitionsPerConsumer ? 1 : 0) != 0);
            Assert.assertTrue((subscribedPartitions2.size() >= minInitialPartitionsPerConsumer ? 1 : 0) != 0);
            Assert.assertTrue((subscribedPartitions2.size() <= maxInitialPartitionsPerConsumer ? 1 : 0) != 0);
            Assert.assertTrue((subscribedPartitions3.size() >= minInitialPartitionsPerConsumer ? 1 : 0) != 0);
            Assert.assertTrue((subscribedPartitions3.size() <= maxInitialPartitionsPerConsumer ? 1 : 0) != 0);
            for (KafkaTopicPartition p : subscribedPartitions1) {
                Assert.assertTrue((boolean)allInitialPartitions.remove(p));
            }
            for (KafkaTopicPartition p : subscribedPartitions2) {
                Assert.assertTrue((boolean)allInitialPartitions.remove(p));
            }
            for (KafkaTopicPartition p : subscribedPartitions3) {
                Assert.assertTrue((boolean)allInitialPartitions.remove(p));
            }
            Assert.assertTrue((boolean)allInitialPartitions.isEmpty());
            subscribedPartitionsToStartOffsets1 = new HashMap();
            subscribedPartitionsToStartOffsets2 = new HashMap();
            subscribedPartitionsToStartOffsets3 = new HashMap();
            FlinkKafkaConsumerBase.initializeSubscribedPartitionsToStartOffsets(subscribedPartitionsToStartOffsets1, newPartitions, (int)0, (int)3, (StartupMode)StartupMode.GROUP_OFFSETS, null);
            FlinkKafkaConsumerBase.initializeSubscribedPartitionsToStartOffsets(subscribedPartitionsToStartOffsets2, newPartitions, (int)1, (int)3, (StartupMode)StartupMode.GROUP_OFFSETS, null);
            FlinkKafkaConsumerBase.initializeSubscribedPartitionsToStartOffsets(subscribedPartitionsToStartOffsets3, newPartitions, (int)2, (int)3, (StartupMode)StartupMode.GROUP_OFFSETS, null);
            ArrayList subscribedPartitions1New = new ArrayList(subscribedPartitionsToStartOffsets1.keySet());
            ArrayList subscribedPartitions2New = new ArrayList(subscribedPartitionsToStartOffsets2.keySet());
            ArrayList subscribedPartitions3New = new ArrayList(subscribedPartitionsToStartOffsets3.keySet());
            Assert.assertTrue((subscribedPartitions1New.size() > subscribedPartitions1.size() ? 1 : 0) != 0);
            Assert.assertTrue((subscribedPartitions2New.size() > subscribedPartitions2.size() ? 1 : 0) != 0);
            Assert.assertTrue((subscribedPartitions3New.size() > subscribedPartitions3.size() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)subscribedPartitions1New.containsAll(subscribedPartitions1));
            Assert.assertTrue((boolean)subscribedPartitions2New.containsAll(subscribedPartitions2));
            Assert.assertTrue((boolean)subscribedPartitions3New.containsAll(subscribedPartitions3));
            Assert.assertTrue((subscribedPartitions1New.size() >= minNewPartitionsPerConsumer ? 1 : 0) != 0);
            Assert.assertTrue((subscribedPartitions1New.size() <= maxNewPartitionsPerConsumer ? 1 : 0) != 0);
            Assert.assertTrue((subscribedPartitions2New.size() >= minNewPartitionsPerConsumer ? 1 : 0) != 0);
            Assert.assertTrue((subscribedPartitions2New.size() <= maxNewPartitionsPerConsumer ? 1 : 0) != 0);
            Assert.assertTrue((subscribedPartitions3New.size() >= minNewPartitionsPerConsumer ? 1 : 0) != 0);
            Assert.assertTrue((subscribedPartitions3New.size() <= maxNewPartitionsPerConsumer ? 1 : 0) != 0);
            for (KafkaTopicPartition p : subscribedPartitions1New) {
                Assert.assertTrue((boolean)allNewPartitions.remove(p));
            }
            for (KafkaTopicPartition p : subscribedPartitions2New) {
                Assert.assertTrue((boolean)allNewPartitions.remove(p));
            }
            for (KafkaTopicPartition p : subscribedPartitions3New) {
                Assert.assertTrue((boolean)allNewPartitions.remove(p));
            }
            Assert.assertTrue((boolean)allNewPartitions.isEmpty());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private boolean contains(List<KafkaTopicPartition> inPartitions, int partition) {
        for (KafkaTopicPartition ktp : inPartitions) {
            if (ktp.getPartition() != partition) continue;
            return true;
        }
        return false;
    }
}

