/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.io.IOException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.util.serialization.JsonRowDeserializationSchema;
import org.apache.flink.streaming.util.serialization.JsonRowSerializationSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;

public class JsonRowSerializationSchemaTest {
    @Test
    public void testRowSerialization() throws IOException {
        String[] fieldNames = new String[]{"f1", "f2", "f3"};
        TypeInformation[] fieldTypes = new TypeInformation[]{Types.INT(), Types.BOOLEAN(), Types.STRING()};
        Row row = new Row(3);
        row.setField(0, (Object)1);
        row.setField(1, (Object)true);
        row.setField(2, (Object)"str");
        Row resultRow = this.serializeAndDeserialize(fieldNames, fieldTypes, row);
        this.assertEqualRows(row, resultRow);
    }

    @Test
    public void testSerializationOfTwoRows() throws IOException {
        String[] fieldNames = new String[]{"f1", "f2", "f3"};
        TypeInformation row = Types.ROW((String[])fieldNames, (TypeInformation[])new TypeInformation[]{Types.INT(), Types.BOOLEAN(), Types.STRING()});
        Row row1 = new Row(3);
        row1.setField(0, (Object)1);
        row1.setField(1, (Object)true);
        row1.setField(2, (Object)"str");
        JsonRowSerializationSchema serializationSchema = new JsonRowSerializationSchema(fieldNames);
        JsonRowDeserializationSchema deserializationSchema = new JsonRowDeserializationSchema(row);
        byte[] bytes = serializationSchema.serialize(row1);
        this.assertEqualRows(row1, deserializationSchema.deserialize(bytes));
        Row row2 = new Row(3);
        row2.setField(0, (Object)10);
        row2.setField(1, (Object)false);
        row2.setField(2, (Object)"newStr");
        bytes = serializationSchema.serialize(row2);
        this.assertEqualRows(row2, deserializationSchema.deserialize(bytes));
    }

    @Test(expected=NullPointerException.class)
    public void testInputValidation() {
        new JsonRowSerializationSchema(null);
    }

    @Test(expected=IllegalStateException.class)
    public void testSerializeRowWithInvalidNumberOfFields() {
        String[] fieldNames = new String[]{"f1", "f2", "f3"};
        Row row = new Row(1);
        row.setField(0, (Object)1);
        JsonRowSerializationSchema serializationSchema = new JsonRowSerializationSchema(fieldNames);
        serializationSchema.serialize(row);
    }

    private Row serializeAndDeserialize(String[] fieldNames, TypeInformation<?>[] fieldTypes, Row row) throws IOException {
        JsonRowSerializationSchema serializationSchema = new JsonRowSerializationSchema(fieldNames);
        JsonRowDeserializationSchema deserializationSchema = new JsonRowDeserializationSchema(Types.ROW((String[])fieldNames, fieldTypes));
        byte[] bytes = serializationSchema.serialize(row);
        return deserializationSchema.deserialize(bytes);
    }

    private void assertEqualRows(Row expectedRow, Row resultRow) {
        Assert.assertEquals((String)"Deserialized row should have expected number of fields", (long)expectedRow.getArity(), (long)resultRow.getArity());
        for (int i = 0; i < expectedRow.getArity(); ++i) {
            Assert.assertEquals((String)String.format("Field number %d should be as in the original row", i), (Object)expectedRow.getField(i), (Object)resultRow.getField(i));
        }
    }
}

