/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.util.serialization.JsonRowDeserializationSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;

public class JsonRowDeserializationSchemaTest {
    @Test
    public void testDeserialization() throws Exception {
        long id = 1238123899121L;
        String name = "asdlkjasjkdla998y1122";
        byte[] bytes = new byte[1024];
        ThreadLocalRandom.current().nextBytes(bytes);
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode root = objectMapper.createObjectNode();
        root.put("id", id);
        root.put("name", name);
        root.put("bytes", bytes);
        byte[] serializedJson = objectMapper.writeValueAsBytes((Object)root);
        JsonRowDeserializationSchema deserializationSchema = new JsonRowDeserializationSchema(Types.ROW((String[])new String[]{"id", "name", "bytes"}, (TypeInformation[])new TypeInformation[]{Types.LONG(), Types.STRING(), Types.PRIMITIVE_ARRAY((TypeInformation)Types.BYTE())}));
        Row deserialized = deserializationSchema.deserialize(serializedJson);
        Assert.assertEquals((long)3L, (long)deserialized.getArity());
        Assert.assertEquals((Object)id, (Object)deserialized.getField(0));
        Assert.assertEquals((Object)name, (Object)deserialized.getField(1));
        Assert.assertArrayEquals((byte[])bytes, (byte[])((byte[])deserialized.getField(2)));
    }

    @Test
    public void testMissingNode() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode root = objectMapper.createObjectNode();
        root.put("id", 123123123);
        byte[] serializedJson = objectMapper.writeValueAsBytes((Object)root);
        JsonRowDeserializationSchema deserializationSchema = new JsonRowDeserializationSchema(Types.ROW((String[])new String[]{"name"}, (TypeInformation[])new TypeInformation[]{Types.STRING()}));
        Row row = deserializationSchema.deserialize(serializedJson);
        Assert.assertEquals((long)1L, (long)row.getArity());
        Assert.assertNull((String)"Missing field not null", (Object)row.getField(0));
        deserializationSchema.setFailOnMissingField(true);
        try {
            deserializationSchema.deserialize(serializedJson);
            Assert.fail((String)"Did not throw expected Exception");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalStateException));
        }
    }

    @Test
    public void testNumberOfFieldNamesAndTypesMismatch() throws Exception {
        try {
            new JsonRowDeserializationSchema(Types.ROW((String[])new String[]{"one", "two", "three"}, (TypeInformation[])new TypeInformation[]{Types.LONG()}));
            Assert.fail((String)"Did not throw expected Exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

