/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.flink.streaming.util.serialization.JSONKeyValueDeserializationSchema;
import org.junit.Assert;
import org.junit.Test;

public class JSONKeyValueDeserializationSchemaTest {
    @Test
    public void testDeserializeWithoutMetadata() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode initialKey = mapper.createObjectNode();
        initialKey.put("index", 4);
        byte[] serializedKey = mapper.writeValueAsBytes((Object)initialKey);
        ObjectNode initialValue = mapper.createObjectNode();
        initialValue.put("word", "world");
        byte[] serializedValue = mapper.writeValueAsBytes((Object)initialValue);
        JSONKeyValueDeserializationSchema schema = new JSONKeyValueDeserializationSchema(false);
        ObjectNode deserializedValue = schema.deserialize(serializedKey, serializedValue, "", 0, 0L);
        Assert.assertTrue((deserializedValue.get("metadata") == null ? 1 : 0) != 0);
        Assert.assertEquals((long)4L, (long)deserializedValue.get("key").get("index").asInt());
        Assert.assertEquals((Object)"world", (Object)deserializedValue.get("value").get("word").asText());
    }

    @Test
    public void testDeserializeWithMetadata() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode initialKey = mapper.createObjectNode();
        initialKey.put("index", 4);
        byte[] serializedKey = mapper.writeValueAsBytes((Object)initialKey);
        ObjectNode initialValue = mapper.createObjectNode();
        initialValue.put("word", "world");
        byte[] serializedValue = mapper.writeValueAsBytes((Object)initialValue);
        JSONKeyValueDeserializationSchema schema = new JSONKeyValueDeserializationSchema(true);
        ObjectNode deserializedValue = schema.deserialize(serializedKey, serializedValue, "topic#1", 3, 4L);
        Assert.assertEquals((long)4L, (long)deserializedValue.get("key").get("index").asInt());
        Assert.assertEquals((Object)"world", (Object)deserializedValue.get("value").get("word").asText());
        Assert.assertEquals((Object)"topic#1", (Object)deserializedValue.get("metadata").get("topic").asText());
        Assert.assertEquals((long)4L, (long)deserializedValue.get("metadata").get("offset").asInt());
        Assert.assertEquals((long)3L, (long)deserializedValue.get("metadata").get("partition").asInt());
    }
}

