/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.flink.streaming.util.serialization.JSONDeserializationSchema;
import org.junit.Assert;
import org.junit.Test;

public class JSONDeserializationSchemaTest {
    @Test
    public void testDeserialize() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode initialValue = mapper.createObjectNode();
        initialValue.put("key", 4).put("value", "world");
        byte[] serializedValue = mapper.writeValueAsBytes((Object)initialValue);
        JSONDeserializationSchema schema = new JSONDeserializationSchema();
        ObjectNode deserializedValue = schema.deserialize(serializedValue);
        Assert.assertEquals((long)4L, (long)deserializedValue.get("key").asInt());
        Assert.assertEquals((Object)"world", (Object)deserializedValue.get("value").asText());
    }
}

