/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.io.IOException;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.streaming.connectors.kafka.testutils.AvroTestUtils;
import org.apache.flink.streaming.util.serialization.AvroRowDeserializationSchema;
import org.apache.flink.streaming.util.serialization.AvroRowSerializationSchema;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;

public class AvroRowDeSerializationSchemaTest {
    @Test
    public void testSerializeDeserializeSimpleRow() throws IOException {
        Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> testData = AvroTestUtils.getSimpleTestData();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema((Class)testData.f0);
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema((Class)testData.f0);
        byte[] bytes = serializationSchema.serialize((Row)testData.f2);
        Row actual = deserializationSchema.deserialize(bytes);
        Assert.assertEquals((Object)testData.f2, (Object)actual);
    }

    @Test
    public void testSerializeSimpleRowSeveralTimes() throws IOException {
        Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> testData = AvroTestUtils.getSimpleTestData();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema((Class)testData.f0);
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema((Class)testData.f0);
        serializationSchema.serialize((Row)testData.f2);
        serializationSchema.serialize((Row)testData.f2);
        byte[] bytes = serializationSchema.serialize((Row)testData.f2);
        Row actual = deserializationSchema.deserialize(bytes);
        Assert.assertEquals((Object)testData.f2, (Object)actual);
    }

    @Test
    public void testDeserializeRowSeveralTimes() throws IOException {
        Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> testData = AvroTestUtils.getSimpleTestData();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema((Class)testData.f0);
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema((Class)testData.f0);
        byte[] bytes = serializationSchema.serialize((Row)testData.f2);
        deserializationSchema.deserialize(bytes);
        deserializationSchema.deserialize(bytes);
        Row actual = deserializationSchema.deserialize(bytes);
        Assert.assertEquals((Object)testData.f2, (Object)actual);
    }

    @Test
    public void testSerializeDeserializeComplexRow() throws IOException {
        Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> testData = AvroTestUtils.getComplexTestData();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema((Class)testData.f0);
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema((Class)testData.f0);
        byte[] bytes = serializationSchema.serialize((Row)testData.f2);
        Row actual = deserializationSchema.deserialize(bytes);
        Assert.assertEquals((Object)testData.f2, (Object)actual);
    }

    @Test
    public void testSerializeComplexRowSeveralTimes() throws IOException {
        Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> testData = AvroTestUtils.getComplexTestData();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema((Class)testData.f0);
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema((Class)testData.f0);
        serializationSchema.serialize((Row)testData.f2);
        serializationSchema.serialize((Row)testData.f2);
        byte[] bytes = serializationSchema.serialize((Row)testData.f2);
        Row actual = deserializationSchema.deserialize(bytes);
        Assert.assertEquals((Object)testData.f2, (Object)actual);
    }

    @Test
    public void testDeserializeComplexRowSeveralTimes() throws IOException {
        Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> testData = AvroTestUtils.getComplexTestData();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema((Class)testData.f0);
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema((Class)testData.f0);
        byte[] bytes = serializationSchema.serialize((Row)testData.f2);
        deserializationSchema.deserialize(bytes);
        deserializationSchema.deserialize(bytes);
        Row actual = deserializationSchema.deserialize(bytes);
        Assert.assertEquals((Object)testData.f2, (Object)actual);
    }
}

