/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.serialization;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.table.Row;
import org.apache.flink.api.table.typeutils.RowTypeInfo;
import org.apache.flink.streaming.util.serialization.DeserializationSchema;
import org.apache.flink.util.Preconditions;

public class JsonRowDeserializationSchema
implements DeserializationSchema<Row> {
    private final String[] fieldNames;
    private final TypeInformation<?>[] fieldTypes;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private boolean failOnMissingField;

    public JsonRowDeserializationSchema(String[] fieldNames, Class<?>[] fieldTypes) {
        this.fieldNames = (String[])Preconditions.checkNotNull((Object)fieldNames, (String)"Field names");
        this.fieldTypes = new TypeInformation[fieldTypes.length];
        for (int i = 0; i < fieldTypes.length; ++i) {
            this.fieldTypes[i] = TypeExtractor.getForClass(fieldTypes[i]);
        }
        Preconditions.checkArgument((fieldNames.length == fieldTypes.length ? 1 : 0) != 0, (Object)"Number of provided field names and types does not match.");
    }

    public JsonRowDeserializationSchema(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        this.fieldNames = (String[])Preconditions.checkNotNull((Object)fieldNames, (String)"Field names");
        this.fieldTypes = (TypeInformation[])Preconditions.checkNotNull(fieldTypes, (String)"Field types");
        Preconditions.checkArgument((fieldNames.length == fieldTypes.length ? 1 : 0) != 0, (Object)"Number of provided field names and types does not match.");
    }

    public Row deserialize(byte[] message) throws IOException {
        try {
            JsonNode root = this.objectMapper.readTree(message);
            Row row = new Row(this.fieldNames.length);
            for (int i = 0; i < this.fieldNames.length; ++i) {
                JsonNode node = root.get(this.fieldNames[i]);
                if (node == null) {
                    if (this.failOnMissingField) {
                        throw new IllegalStateException("Failed to find field with name '" + this.fieldNames[i] + "'.");
                    }
                    row.setField(i, null);
                    continue;
                }
                Object value = this.objectMapper.treeToValue((TreeNode)node, this.fieldTypes[i].getTypeClass());
                row.setField(i, value);
            }
            return row;
        }
        catch (Throwable t) {
            throw new IOException("Failed to deserialize JSON object.", t);
        }
    }

    public boolean isEndOfStream(Row nextElement) {
        return false;
    }

    public TypeInformation<Row> getProducedType() {
        return new RowTypeInfo(this.fieldTypes);
    }

    public void setFailOnMissingField(boolean failOnMissingField) {
        this.failOnMissingField = failOnMissingField;
    }
}

