/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.util.serialization.KeyedDeserializationSchema;

public class JSONKeyValueDeserializationSchema
implements KeyedDeserializationSchema<ObjectNode> {
    private final boolean includeMetadata;
    private ObjectMapper mapper;

    public JSONKeyValueDeserializationSchema(boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
    }

    @Override
    public ObjectNode deserialize(byte[] messageKey, byte[] message, String topic, int partition, long offset) throws IOException {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
        }
        ObjectNode node = this.mapper.createObjectNode();
        node.set("key", (JsonNode)this.mapper.readValue(messageKey, JsonNode.class));
        node.set("value", (JsonNode)this.mapper.readValue(message, JsonNode.class));
        if (this.includeMetadata) {
            node.putObject("metadata").put("offset", offset).put("topic", topic).put("partition", partition);
        }
        return node;
    }

    @Override
    public boolean isEndOfStream(ObjectNode nextElement) {
        return false;
    }

    public TypeInformation<ObjectNode> getProducedType() {
        return TypeExtractor.getForClass(ObjectNode.class);
    }
}

