/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.internals;

import javax.annotation.Nullable;
import org.apache.flink.streaming.api.functions.AssignerWithPunctuatedWatermarks;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartitionState;

public final class KafkaTopicPartitionStateWithPunctuatedWatermarks<T, KPH>
extends KafkaTopicPartitionState<KPH> {
    private final AssignerWithPunctuatedWatermarks<T> timestampsAndWatermarks;
    private volatile long partitionWatermark;

    public KafkaTopicPartitionStateWithPunctuatedWatermarks(KafkaTopicPartition partition, KPH kafkaPartitionHandle, AssignerWithPunctuatedWatermarks<T> timestampsAndWatermarks) {
        super(partition, kafkaPartitionHandle);
        this.timestampsAndWatermarks = timestampsAndWatermarks;
        this.partitionWatermark = Long.MIN_VALUE;
    }

    public long getTimestampForRecord(T record) {
        return this.timestampsAndWatermarks.extractTimestamp(record, Long.MIN_VALUE);
    }

    @Nullable
    public Watermark checkAndGetNewWatermark(T record, long timestamp) {
        Watermark mark = this.timestampsAndWatermarks.checkAndGetNextWatermark(record, timestamp);
        if (mark != null && mark.getTimestamp() > this.partitionWatermark) {
            this.partitionWatermark = mark.getTimestamp();
            return mark;
        }
        return null;
    }

    public long getCurrentPartitionWatermark() {
        return this.partitionWatermark;
    }

    @Override
    public String toString() {
        return "KafkaTopicPartitionStateWithPunctuatedWatermarks: partition=" + this.getKafkaTopicPartition() + ", offset=" + this.getOffset() + ", watermark=" + this.partitionWatermark;
    }
}

