/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.internals;

import org.apache.flink.streaming.api.functions.AssignerWithPeriodicWatermarks;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartitionState;

public final class KafkaTopicPartitionStateWithPeriodicWatermarks<T, KPH>
extends KafkaTopicPartitionState<KPH> {
    private final AssignerWithPeriodicWatermarks<T> timestampsAndWatermarks;
    private long partitionWatermark;

    public KafkaTopicPartitionStateWithPeriodicWatermarks(KafkaTopicPartition partition, KPH kafkaPartitionHandle, AssignerWithPeriodicWatermarks<T> timestampsAndWatermarks) {
        super(partition, kafkaPartitionHandle);
        this.timestampsAndWatermarks = timestampsAndWatermarks;
        this.partitionWatermark = Long.MIN_VALUE;
    }

    public long getTimestampForRecord(T record) {
        return this.timestampsAndWatermarks.extractTimestamp(record, Long.MIN_VALUE);
    }

    public long getCurrentWatermarkTimestamp() {
        Watermark wm = this.timestampsAndWatermarks.getCurrentWatermark();
        if (wm != null) {
            this.partitionWatermark = Math.max(this.partitionWatermark, wm.getTimestamp());
        }
        return this.partitionWatermark;
    }

    @Override
    public String toString() {
        return "KafkaTopicPartitionStateWithPeriodicWatermarks: partition=" + this.getKafkaTopicPartition() + ", offset=" + this.getOffset() + ", watermark=" + this.partitionWatermark;
    }
}

