/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.io.File;
import java.net.BindException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import kafka.admin.AdminUtils;
import kafka.api.PartitionMetadata;
import kafka.cluster.BrokerEndPoint;
import kafka.common.KafkaException;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.SystemTime$;
import kafka.utils.Time;
import kafka.utils.ZkUtils;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.commons.collections.list.UnmodifiableList;
import org.apache.commons.io.FileUtils;
import org.apache.curator.test.TestingServer;
import org.apache.flink.networking.NetworkFailuresProxy;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumer09;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumerBase;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaProducer09;
import org.apache.flink.streaming.connectors.kafka.KafkaDeserializationSchema;
import org.apache.flink.streaming.connectors.kafka.KafkaTestEnvironment;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import org.apache.flink.streaming.connectors.kafka.testutils.ZooKeeperStringSerializer;
import org.apache.flink.streaming.util.serialization.KeyedSerializationSchema;
import org.apache.flink.util.NetUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.Seq;

public class KafkaTestEnvironmentImpl
extends KafkaTestEnvironment {
    protected static final Logger LOG = LoggerFactory.getLogger(KafkaTestEnvironmentImpl.class);
    private File tmpZkDir;
    private File tmpKafkaParent;
    private List<File> tmpKafkaDirs;
    private List<KafkaServer> brokers;
    private TestingServer zookeeper;
    private String zookeeperConnectionString;
    private String brokerConnectionString = "";
    private Properties standardProps;
    private String zkTimeout = "30000";
    private KafkaTestEnvironment.Config config;

    public String getBrokerConnectionString() {
        return this.brokerConnectionString;
    }

    public Properties getStandardProperties() {
        return this.standardProps;
    }

    public String getVersion() {
        return "0.9";
    }

    public List<KafkaServer> getBrokers() {
        return this.brokers;
    }

    public <T> FlinkKafkaConsumerBase<T> getConsumer(List<String> topics, KafkaDeserializationSchema<T> readSchema, Properties props) {
        return new FlinkKafkaConsumer09(topics, readSchema, props);
    }

    public <K, V> Collection<ConsumerRecord<K, V>> getAllRecordsFromTopic(Properties properties, String topic, int partition, long timeout) {
        ArrayList<ConsumerRecord> result = new ArrayList<ConsumerRecord>();
        try (KafkaConsumer consumer = new KafkaConsumer(properties);){
            boolean processedAtLeastOneRecord;
            consumer.assign(Arrays.asList(new TopicPartition(topic, partition)));
            do {
                processedAtLeastOneRecord = false;
                for (ConsumerRecord record : consumer.poll(timeout)) {
                    result.add(record);
                    processedAtLeastOneRecord = true;
                }
            } while (processedAtLeastOneRecord);
            consumer.commitSync();
        }
        return UnmodifiableList.decorate(result);
    }

    public <T> StreamSink<T> getProducerSink(String topic, KeyedSerializationSchema<T> serSchema, Properties props, FlinkKafkaPartitioner<T> partitioner) {
        FlinkKafkaProducer09 prod = new FlinkKafkaProducer09(topic, serSchema, props, partitioner);
        prod.setFlushOnCheckpoint(true);
        return new StreamSink((SinkFunction)prod);
    }

    public <T> DataStreamSink<T> produceIntoKafka(DataStream<T> stream, String topic, KeyedSerializationSchema<T> serSchema, Properties props, FlinkKafkaPartitioner<T> partitioner) {
        FlinkKafkaProducer09 prod = new FlinkKafkaProducer09(topic, serSchema, props, partitioner);
        prod.setFlushOnCheckpoint(true);
        return stream.addSink((SinkFunction)prod);
    }

    public KafkaTestEnvironment.KafkaOffsetHandler createOffsetHandler() {
        return new KafkaOffsetHandlerImpl();
    }

    public void restartBroker(int leaderId) throws Exception {
        this.brokers.set(leaderId, this.getKafkaServer(leaderId, this.tmpKafkaDirs.get(leaderId)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLeaderToShutDown(String topic) throws Exception {
        try (ZkUtils zkUtils = this.getZkUtils();){
            Seq partitionMetadata;
            PartitionMetadata firstPart = null;
            do {
                if (firstPart == null) continue;
                LOG.info("Unable to find leader. error code {}", (Object)firstPart.errorCode());
                Thread.sleep(150L);
            } while ((firstPart = (PartitionMetadata)(partitionMetadata = AdminUtils.fetchTopicMetadataFromZk((String)topic, (ZkUtils)zkUtils).partitionsMetadata()).head()).errorCode() != 0);
            int n = ((BrokerEndPoint)firstPart.leader().get()).id();
            return n;
        }
    }

    public int getBrokerId(KafkaServer server) {
        return server.config().brokerId();
    }

    public boolean isSecureRunSupported() {
        return true;
    }

    public void prepare(KafkaTestEnvironment.Config config) throws Exception {
        if (config.isSecureMode()) {
            config.setKafkaServersNumber(1);
            this.zkTimeout = String.valueOf(Integer.parseInt(this.zkTimeout) * 15);
        }
        this.config = config;
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        this.tmpZkDir = new File(tempDir, "kafkaITcase-zk-dir-" + UUID.randomUUID().toString());
        Assert.assertTrue((String)"cannot create zookeeper temp dir", (boolean)this.tmpZkDir.mkdirs());
        this.tmpKafkaParent = new File(tempDir, "kafkaITcase-kafka-dir-" + UUID.randomUUID().toString());
        Assert.assertTrue((String)"cannot create kafka temp dir", (boolean)this.tmpKafkaParent.mkdirs());
        this.tmpKafkaDirs = new ArrayList<File>(config.getKafkaServersNumber());
        for (int i = 0; i < config.getKafkaServersNumber(); ++i) {
            File tmpDir = new File(this.tmpKafkaParent, "server-" + i);
            Assert.assertTrue((String)"cannot create kafka temp dir", (boolean)tmpDir.mkdir());
            this.tmpKafkaDirs.add(tmpDir);
        }
        this.zookeeper = null;
        this.brokers = null;
        LOG.info("Starting Zookeeper");
        this.zookeeper = new TestingServer(-1, this.tmpZkDir);
        this.zookeeperConnectionString = this.zookeeper.getConnectString();
        LOG.info("zookeeperConnectionString: {}", (Object)this.zookeeperConnectionString);
        LOG.info("Starting KafkaServer");
        this.brokers = new ArrayList<KafkaServer>(config.getKafkaServersNumber());
        SecurityProtocol securityProtocol = config.isSecureMode() ? SecurityProtocol.SASL_PLAINTEXT : SecurityProtocol.PLAINTEXT;
        for (int i = 0; i < config.getKafkaServersNumber(); ++i) {
            KafkaServer kafkaServer = this.getKafkaServer(i, this.tmpKafkaDirs.get(i));
            this.brokers.add(kafkaServer);
            this.brokerConnectionString = this.brokerConnectionString + NetUtils.hostAndPortToUrlString((String)"localhost", (int)kafkaServer.socketServer().boundPort(securityProtocol));
            this.brokerConnectionString = this.brokerConnectionString + ",";
        }
        LOG.info("ZK and KafkaServer started.");
        LOG.info("brokerConnectionString --> {}", (Object)this.brokerConnectionString);
        this.standardProps = new Properties();
        this.standardProps.setProperty("zookeeper.connect", this.zookeeperConnectionString);
        this.standardProps.setProperty("bootstrap.servers", this.brokerConnectionString);
        this.standardProps.setProperty("group.id", "flink-tests");
        this.standardProps.setProperty("enable.auto.commit", "false");
        this.standardProps.setProperty("zookeeper.session.timeout.ms", this.zkTimeout);
        this.standardProps.setProperty("zookeeper.connection.timeout.ms", this.zkTimeout);
        this.standardProps.setProperty("auto.offset.reset", "earliest");
        this.standardProps.setProperty("max.partition.fetch.bytes", "256");
    }

    public void shutdown() throws Exception {
        for (KafkaServer broker : this.brokers) {
            if (broker == null) continue;
            broker.shutdown();
        }
        this.brokers.clear();
        if (this.zookeeper != null) {
            try {
                this.zookeeper.stop();
                this.zookeeper.close();
            }
            catch (Exception e) {
                LOG.warn("ZK.stop() failed", (Throwable)e);
            }
            this.zookeeper = null;
        }
        if (this.tmpKafkaParent != null && this.tmpKafkaParent.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.tmpKafkaParent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.tmpZkDir != null && this.tmpZkDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.tmpZkDir);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.shutdown();
    }

    public ZkUtils getZkUtils() {
        LOG.info("In getZKUtils:: zookeeperConnectionString = {}", (Object)this.zookeeperConnectionString);
        ZkClient creator = new ZkClient(this.zookeeperConnectionString, Integer.valueOf(this.standardProps.getProperty("zookeeper.session.timeout.ms")).intValue(), Integer.valueOf(this.standardProps.getProperty("zookeeper.connection.timeout.ms")).intValue(), (ZkSerializer)new ZooKeeperStringSerializer());
        return ZkUtils.apply((ZkClient)creator, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTestTopic(String topic, int numberOfPartitions, int replicationFactor, Properties topicConfig) {
        LOG.info("Creating topic {}", (Object)topic);
        try (ZkUtils zkUtils = this.getZkUtils();){
            AdminUtils.createTopic((ZkUtils)zkUtils, (String)topic, (int)numberOfPartitions, (int)replicationFactor, (Properties)topicConfig);
        }
        LOG.info("Topic {} create request is successfully posted", (Object)topic);
        long deadline = System.nanoTime() + (long)Integer.parseInt(this.zkTimeout) * 1000000L;
        do {
            try {
                if (this.config.isSecureMode()) {
                    int wait = Integer.parseInt(this.zkTimeout) / 100;
                    LOG.info("waiting for {} msecs before the topic {} can be checked", (Object)wait, (Object)topic);
                    Thread.sleep(wait);
                } else {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException wait) {
                // empty catch block
            }
            LOG.info("Validating if the topic {} has been created or not", (Object)topic);
            ZkUtils checkZKConn = this.getZkUtils();
            if (AdminUtils.topicExists((ZkUtils)checkZKConn, (String)topic)) {
                LOG.info("topic {} has been created successfully", (Object)topic);
                checkZKConn.close();
                return;
            }
            LOG.info("topic {} has not been created yet. Will check again...", (Object)topic);
            checkZKConn.close();
        } while (System.nanoTime() < deadline);
        Assert.fail((String)"Test topic could not be created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTestTopic(String topic) {
        try (ZkUtils zkUtils = this.getZkUtils();){
            LOG.info("Deleting topic {}", (Object)topic);
            ZkClient zk = new ZkClient(this.zookeeperConnectionString, Integer.valueOf(this.standardProps.getProperty("zookeeper.session.timeout.ms")).intValue(), Integer.valueOf(this.standardProps.getProperty("zookeeper.connection.timeout.ms")).intValue(), (ZkSerializer)new ZooKeeperStringSerializer());
            AdminUtils.deleteTopic((ZkUtils)zkUtils, (String)topic);
            zk.close();
        }
    }

    protected KafkaServer getKafkaServer(int brokerId, File tmpFolder) throws Exception {
        Properties kafkaProperties = new Properties();
        kafkaProperties.put("advertised.host.name", "localhost");
        kafkaProperties.put("broker.id", Integer.toString(brokerId));
        kafkaProperties.put("log.dir", tmpFolder.toString());
        kafkaProperties.put("zookeeper.connect", this.zookeeperConnectionString);
        kafkaProperties.put("message.max.bytes", String.valueOf(0x3200000));
        kafkaProperties.put("replica.fetch.max.bytes", String.valueOf(0x3200000));
        kafkaProperties.put("zookeeper.session.timeout.ms", this.zkTimeout);
        kafkaProperties.put("zookeeper.connection.timeout.ms", this.zkTimeout);
        if (this.config.getKafkaServerProperties() != null) {
            kafkaProperties.putAll((Map<?, ?>)this.config.getKafkaServerProperties());
        }
        int numTries = 5;
        for (int i = 1; i <= 5; ++i) {
            int kafkaPort = NetUtils.getAvailablePort();
            kafkaProperties.put("port", Integer.toString(kafkaPort));
            if (this.config.isHideKafkaBehindProxy()) {
                NetworkFailuresProxy proxy = this.createProxy("localhost", kafkaPort);
                kafkaProperties.put("advertised.port", (Object)proxy.getLocalPort());
            }
            if (this.config.isSecureMode()) {
                LOG.info("Adding Kafka secure configurations");
                kafkaProperties.put("listeners", "SASL_PLAINTEXT://localhost:" + kafkaPort);
                kafkaProperties.put("advertised.listeners", "SASL_PLAINTEXT://localhost:" + kafkaPort);
                kafkaProperties.putAll((Map<?, ?>)this.getSecureProperties());
            }
            KafkaConfig kafkaConfig = new KafkaConfig((Map)kafkaProperties);
            try {
                Option stringNone = Option.apply(null);
                KafkaServer server = new KafkaServer(kafkaConfig, (Time)SystemTime$.MODULE$, stringNone);
                server.startup();
                return server;
            }
            catch (KafkaException e) {
                if (!(e.getCause() instanceof BindException)) {
                    throw e;
                }
                LOG.info("Port conflict when starting Kafka Broker. Retrying...");
                continue;
            }
        }
        throw new Exception("Could not start Kafka after 5 retries due to port conflicts.");
    }

    public Properties getSecureProperties() {
        Properties prop = new Properties();
        if (this.config.isSecureMode()) {
            prop.put("security.inter.broker.protocol", "SASL_PLAINTEXT");
            prop.put("security.protocol", "SASL_PLAINTEXT");
            prop.put("sasl.kerberos.service.name", "kafka");
            prop.setProperty("zookeeper.session.timeout.ms", this.zkTimeout);
            prop.setProperty("zookeeper.connection.timeout.ms", this.zkTimeout);
            prop.setProperty("metadata.fetch.timeout.ms", "120000");
        }
        return prop;
    }

    private class KafkaOffsetHandlerImpl
    implements KafkaTestEnvironment.KafkaOffsetHandler {
        private final KafkaConsumer<byte[], byte[]> offsetClient;

        public KafkaOffsetHandlerImpl() {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)KafkaTestEnvironmentImpl.this.standardProps);
            props.setProperty("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
            props.setProperty("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
            this.offsetClient = new KafkaConsumer(props);
        }

        public Long getCommittedOffset(String topicName, int partition) {
            OffsetAndMetadata committed = this.offsetClient.committed(new TopicPartition(topicName, partition));
            return committed != null ? Long.valueOf(committed.offset()) : null;
        }

        public void setCommittedOffset(String topicName, int partition, long offset) {
            HashMap<TopicPartition, OffsetAndMetadata> partitionAndOffset = new HashMap<TopicPartition, OffsetAndMetadata>();
            partitionAndOffset.put(new TopicPartition(topicName, partition), new OffsetAndMetadata(offset));
            this.offsetClient.commitSync(partitionAndOffset);
        }

        public void close() {
            this.offsetClient.close();
        }
    }
}

