/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.flink.streaming.connectors.kafka.config.StartupMode;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.descriptors.ConnectorDescriptorValidator;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.KafkaValidator;
import org.apache.flink.util.Preconditions;

public class Kafka
extends ConnectorDescriptor {
    private String version;
    private String topic;
    private StartupMode startupMode;
    private Map<Integer, Long> specificOffsets;
    private Map<String, String> kafkaProperties;
    private String sinkPartitionerType;
    private Class<? extends FlinkKafkaPartitioner> sinkPartitionerClass;

    public Kafka() {
        super("kafka", 1, true);
    }

    public Kafka version(String version) {
        Preconditions.checkNotNull((Object)version);
        this.version = version;
        return this;
    }

    public Kafka topic(String topic) {
        Preconditions.checkNotNull((Object)topic);
        this.topic = topic;
        return this;
    }

    public Kafka properties(Properties properties) {
        Preconditions.checkNotNull((Object)properties);
        if (this.kafkaProperties == null) {
            this.kafkaProperties = new HashMap<String, String>();
        }
        this.kafkaProperties.clear();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.kafkaProperties.put((String)k, (String)v)));
        return this;
    }

    public Kafka property(String key, String value) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)value);
        if (this.kafkaProperties == null) {
            this.kafkaProperties = new HashMap<String, String>();
        }
        this.kafkaProperties.put(key, value);
        return this;
    }

    public Kafka startFromEarliest() {
        this.startupMode = StartupMode.EARLIEST;
        this.specificOffsets = null;
        return this;
    }

    public Kafka startFromLatest() {
        this.startupMode = StartupMode.LATEST;
        this.specificOffsets = null;
        return this;
    }

    public Kafka startFromGroupOffsets() {
        this.startupMode = StartupMode.GROUP_OFFSETS;
        this.specificOffsets = null;
        return this;
    }

    public Kafka startFromSpecificOffsets(Map<Integer, Long> specificOffsets) {
        this.startupMode = StartupMode.SPECIFIC_OFFSETS;
        this.specificOffsets = (Map)Preconditions.checkNotNull(specificOffsets);
        return this;
    }

    public Kafka startFromSpecificOffset(int partition, long specificOffset) {
        this.startupMode = StartupMode.SPECIFIC_OFFSETS;
        if (this.specificOffsets == null) {
            this.specificOffsets = new HashMap<Integer, Long>();
        }
        this.specificOffsets.put(partition, specificOffset);
        return this;
    }

    public Kafka sinkPartitionerFixed() {
        this.sinkPartitionerType = "fixed";
        this.sinkPartitionerClass = null;
        return this;
    }

    public Kafka sinkPartitionerRoundRobin() {
        this.sinkPartitionerType = "round-robin";
        this.sinkPartitionerClass = null;
        return this;
    }

    public Kafka sinkPartitionerCustom(Class<? extends FlinkKafkaPartitioner> partitionerClass) {
        this.sinkPartitionerType = "custom";
        this.sinkPartitionerClass = (Class)Preconditions.checkNotNull(partitionerClass);
        return this;
    }

    public void addConnectorProperties(DescriptorProperties properties) {
        if (this.version != null) {
            properties.putString(ConnectorDescriptorValidator.CONNECTOR_VERSION(), this.version);
        }
        if (this.topic != null) {
            properties.putString("connector.topic", this.topic);
        }
        if (this.startupMode != null) {
            properties.putString("connector.startup-mode", KafkaValidator.normalizeStartupMode(this.startupMode));
        }
        if (this.specificOffsets != null) {
            ArrayList<List<String>> values = new ArrayList<List<String>>();
            for (Map.Entry<Integer, Long> specificOffset : this.specificOffsets.entrySet()) {
                values.add(Arrays.asList(specificOffset.getKey().toString(), specificOffset.getValue().toString()));
            }
            properties.putIndexedFixedProperties("connector.specific-offsets", Arrays.asList("partition", "offset"), values);
        }
        if (this.kafkaProperties != null) {
            properties.putIndexedFixedProperties("connector.properties", Arrays.asList("key", "value"), this.kafkaProperties.entrySet().stream().map(e -> Arrays.asList((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()));
        }
        if (this.sinkPartitionerType != null) {
            properties.putString("connector.sink-partitioner", this.sinkPartitionerType);
            if (this.sinkPartitionerClass != null) {
                properties.putClass("connector.sink-partitioner-class", this.sinkPartitionerClass);
            }
        }
    }
}

