/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.internal;

import java.io.Closeable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.Internal;
import org.apache.flink.kafka09.shaded.org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

@ThreadSafe
@Internal
public final class Handover
implements Closeable {
    private final Object lock = new Object();
    private ConsumerRecords<byte[], byte[]> next;
    private Throwable error;
    private boolean wakeupProducer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ConsumerRecords<byte[], byte[]> pollNext() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            while (this.next == null && this.error == null) {
                this.lock.wait();
            }
            ConsumerRecords<byte[], byte[]> n = this.next;
            if (n != null) {
                this.next = null;
                this.lock.notifyAll();
                return n;
            }
            ExceptionUtils.rethrowException((Throwable)this.error, (String)this.error.getMessage());
            return ConsumerRecords.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produce(ConsumerRecords<byte[], byte[]> element) throws InterruptedException, WakeupException, ClosedException {
        Preconditions.checkNotNull(element);
        Object object = this.lock;
        synchronized (object) {
            while (this.next != null && !this.wakeupProducer) {
                this.lock.wait();
            }
            this.wakeupProducer = false;
            if (this.next != null) {
                throw new WakeupException();
            }
            if (this.error != null) {
                throw new ClosedException();
            }
            this.next = element;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportError(Throwable t) {
        Preconditions.checkNotNull((Object)t);
        Object object = this.lock;
        synchronized (object) {
            if (this.error == null) {
                this.error = t;
            }
            this.next = null;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.next = null;
            this.wakeupProducer = false;
            if (this.error == null) {
                this.error = new ClosedException();
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeupProducer() {
        Object object = this.lock;
        synchronized (object) {
            this.wakeupProducer = true;
            this.lock.notifyAll();
        }
    }

    public static final class WakeupException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static final class ClosedException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

