/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka09.shaded.org.apache.kafka.common.security.kerberos;

import java.util.Date;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.security.authenticator.SaslClientAuthenticator;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.utils.Shell;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.utils.SystemTime;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.utils.Time;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Login {
    private static final Logger log = LoggerFactory.getLogger(Login.class);
    private static final Random RNG = new Random();
    private final Thread t;
    private final boolean isKrbTicket;
    private final boolean isUsingTicketCache;
    private final String loginContextName;
    private final String principal;
    private final Time time = new SystemTime();
    private final CallbackHandler callbackHandler = new SaslClientAuthenticator.ClientCallbackHandler();
    private final double ticketRenewWindowFactor;
    private final double ticketRenewJitter;
    private final long minTimeBeforeRelogin;
    private final String kinitCmd;
    private volatile Subject subject;
    private LoginContext login;
    private long lastLogin;

    public Login(String loginContextName, Map<String, ?> configs) throws LoginException {
        this.loginContextName = loginContextName;
        this.ticketRenewWindowFactor = (Double)configs.get("sasl.kerberos.ticket.renew.window.factor");
        this.ticketRenewJitter = (Double)configs.get("sasl.kerberos.ticket.renew.jitter");
        this.minTimeBeforeRelogin = (Long)configs.get("sasl.kerberos.min.time.before.relogin");
        this.kinitCmd = (String)configs.get("sasl.kerberos.kinit.cmd");
        this.lastLogin = this.currentElapsedTime();
        this.login = this.login(loginContextName);
        this.subject = this.login.getSubject();
        this.isKrbTicket = !this.subject.getPrivateCredentials(KerberosTicket.class).isEmpty();
        AppConfigurationEntry[] entries = Configuration.getConfiguration().getAppConfigurationEntry(loginContextName);
        if (entries.length == 0) {
            this.isUsingTicketCache = false;
            this.principal = null;
        } else {
            AppConfigurationEntry entry = entries[0];
            if (entry.getOptions().get("useTicketCache") != null) {
                String val = (String)entry.getOptions().get("useTicketCache");
                this.isUsingTicketCache = val.equals("true");
            } else {
                this.isUsingTicketCache = false;
            }
            this.principal = entry.getOptions().get("principal") != null ? (String)entry.getOptions().get("principal") : null;
        }
        if (!this.isKrbTicket) {
            log.debug("It is not a Kerberos ticket");
            this.t = null;
            return;
        }
        log.debug("It is a Kerberos ticket");
        this.t = Utils.newThread("kafka-kerberos-refresh-thread", new Runnable(){

            @Override
            public void run() {
                log.info("TGT refresh thread started.");
                block12: while (true) {
                    Date nextRefreshDate;
                    long nextRefresh;
                    KerberosTicket tgt = Login.this.getTGT();
                    long now = Login.this.currentWallTime();
                    if (tgt == null) {
                        nextRefresh = now + Login.this.minTimeBeforeRelogin;
                        nextRefreshDate = new Date(nextRefresh);
                        log.warn("No TGT found: will try again at {}", (Object)nextRefreshDate);
                    } else {
                        nextRefresh = Login.this.getRefreshTime(tgt);
                        long expiry = tgt.getEndTime().getTime();
                        Date expiryDate = new Date(expiry);
                        if (Login.this.isUsingTicketCache && tgt.getRenewTill() != null && tgt.getRenewTill().getTime() < expiry) {
                            log.error("The TGT cannot be renewed beyond the next expiry date: {}.This process will not be able to authenticate new SASL connections after that time (for example, it will not be able to authenticate a new connection with a Kafka Broker).  Ask your system administrator to either increase the 'renew until' time by doing : 'modprinc -maxrenewlife {} ' within kadmin, or instead, to generate a keytab for {}. Because the TGT's expiry cannot be further extended by refreshing, exiting refresh thread now.", new Object[]{expiryDate, Login.this.principal, Login.this.principal});
                            return;
                        }
                        if (nextRefresh > expiry || now + Login.this.minTimeBeforeRelogin > expiry) {
                            log.info("Refreshing now because expiry is before next scheduled refresh time.");
                            nextRefresh = now;
                        } else {
                            if (nextRefresh < now + Login.this.minTimeBeforeRelogin) {
                                Date until = new Date(nextRefresh);
                                Date newUntil = new Date(now + Login.this.minTimeBeforeRelogin);
                                log.warn("TGT refresh thread time adjusted from {} to {} since the former is sooner than the minimum refresh interval ({} seconds) from now.", new Object[]{until, newUntil, Login.this.minTimeBeforeRelogin / 1000L});
                            }
                            nextRefresh = Math.max(nextRefresh, now + Login.this.minTimeBeforeRelogin);
                        }
                        nextRefreshDate = new Date(nextRefresh);
                        if (nextRefresh > expiry) {
                            log.error("Next refresh: {} is later than expiry {}. This may indicate a clock skew problem.Check that this host and the KDC hosts' clocks are in sync. Exiting refresh thread.", (Object)nextRefreshDate, (Object)expiryDate);
                            return;
                        }
                    }
                    if (now < nextRefresh) {
                        Date until = new Date(nextRefresh);
                        log.info("TGT refresh sleeping until: {}", (Object)until);
                        try {
                            Thread.sleep(nextRefresh - now);
                        }
                        catch (InterruptedException ie) {
                            log.warn("TGT renewal thread has been interrupted and will exit.");
                            return;
                        }
                    } else {
                        log.error("NextRefresh: {} is in the past: exiting refresh thread. Check clock sync between this host and KDC - (KDC's clock is likely ahead of this host). Manual intervention will be required for this client to successfully authenticate. Exiting refresh thread.", (Object)nextRefreshDate);
                        return;
                    }
                    if (Login.this.isUsingTicketCache) {
                        String kinitArgs = "-R";
                        for (int retry = 1; retry >= 0; --retry) {
                            try {
                                log.debug("Running ticket cache refresh command: {} {}", (Object)Login.this.kinitCmd, (Object)kinitArgs);
                                Shell.execCommand(Login.this.kinitCmd, kinitArgs);
                                break;
                            }
                            catch (Exception e) {
                                if (retry > 0) {
                                    try {
                                        Thread.sleep(10000L);
                                        continue;
                                    }
                                    catch (InterruptedException ie) {
                                        log.error("Interrupted while renewing TGT, exiting Login thread");
                                        return;
                                    }
                                }
                                log.warn("Could not renew TGT due to problem running shell command: '" + Login.this.kinitCmd + " " + kinitArgs + "'" + "; exception was: " + e + ". Exiting refresh thread.", (Throwable)e);
                                return;
                            }
                        }
                    }
                    try {
                        int retry = 1;
                        while (true) {
                            if (retry < 0) continue block12;
                            try {
                                Login.this.reLogin();
                                continue block12;
                            }
                            catch (LoginException le) {
                                if (retry > 0) {
                                    --retry;
                                    try {
                                        Thread.sleep(10000L);
                                        continue;
                                    }
                                    catch (InterruptedException e) {
                                        log.error("Interrupted during login retry after LoginException:", (Throwable)le);
                                        throw le;
                                    }
                                }
                                log.error("Could not refresh TGT for principal: " + Login.this.principal + ".", (Throwable)le);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (LoginException le) {
                        log.error("Failed to refresh TGT: refresh thread exiting now.", (Throwable)le);
                        return;
                    }
                }
            }
        }, true);
    }

    public void startThreadIfNeeded() {
        if (this.t != null) {
            this.t.start();
        }
    }

    public void shutdown() {
        if (this.t != null && this.t.isAlive()) {
            this.t.interrupt();
            try {
                this.t.join();
            }
            catch (InterruptedException e) {
                log.warn("Error while waiting for Login thread to shutdown: " + e, (Throwable)e);
            }
        }
    }

    public Subject subject() {
        return this.subject;
    }

    private synchronized LoginContext login(String loginContextName) throws LoginException {
        String jaasConfigFile = System.getProperty("java.security.auth.login.config");
        if (jaasConfigFile == null) {
            throw new IllegalArgumentException("You must pass java.security.auth.login.config in secure mode.");
        }
        AppConfigurationEntry[] configEntries = Configuration.getConfiguration().getAppConfigurationEntry(loginContextName);
        if (configEntries == null) {
            String errorMessage = "Could not find a '" + loginContextName + "' entry in `" + jaasConfigFile + "`.";
            throw new IllegalArgumentException(errorMessage);
        }
        LoginContext loginContext = new LoginContext(loginContextName, this.callbackHandler);
        loginContext.login();
        log.info("Successfully logged in.");
        return loginContext;
    }

    private long getRefreshTime(KerberosTicket tgt) {
        long start = tgt.getStartTime().getTime();
        long expires = tgt.getEndTime().getTime();
        log.info("TGT valid starting at: {}", (Object)tgt.getStartTime());
        log.info("TGT expires: {}", (Object)tgt.getEndTime());
        long proposedRefresh = start + (long)((double)(expires - start) * (this.ticketRenewWindowFactor + this.ticketRenewJitter * RNG.nextDouble()));
        if (proposedRefresh > expires) {
            return this.currentWallTime();
        }
        return proposedRefresh;
    }

    private synchronized KerberosTicket getTGT() {
        Set<KerberosTicket> tickets = this.subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            KerberosPrincipal server = ticket.getServer();
            if (!server.getName().equals("krbtgt/" + server.getRealm() + "@" + server.getRealm())) continue;
            log.debug("Found TGT {}.", (Object)ticket);
            return ticket;
        }
        return null;
    }

    private boolean hasSufficientTimeElapsed() {
        long now = this.currentElapsedTime();
        if (now - this.lastLogin < this.minTimeBeforeRelogin) {
            log.warn("Not attempting to re-login since the last re-login was attempted less than {} seconds before.", (Object)(this.minTimeBeforeRelogin / 1000L));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reLogin() throws LoginException {
        if (!this.isKrbTicket) {
            return;
        }
        if (this.login == null) {
            throw new LoginException("Login must be done first");
        }
        if (!this.hasSufficientTimeElapsed()) {
            return;
        }
        log.info("Initiating logout for {}", (Object)this.principal);
        Class<Login> clazz = Login.class;
        synchronized (Login.class) {
            this.lastLogin = this.currentElapsedTime();
            this.login.logout();
            this.login = new LoginContext(this.loginContextName, this.subject);
            log.info("Initiating re-login for {}", (Object)this.principal);
            this.login.login();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private long currentElapsedTime() {
        return this.time.nanoseconds() / 1000000L;
    }

    private long currentWallTime() {
        return this.time.milliseconds();
    }
}

