/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka09.shaded.org.apache.kafka.common.security.authenticator;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.KafkaException;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.network.Authenticator;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.network.NetworkReceive;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.network.NetworkSend;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.network.TransportLayer;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.security.auth.PrincipalBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslClientAuthenticator
implements Authenticator {
    private static final Logger LOG = LoggerFactory.getLogger(SaslClientAuthenticator.class);
    private final Subject subject;
    private final String servicePrincipal;
    private final String host;
    private final String node;
    private SaslClient saslClient;
    private String clientPrincipalName;
    private TransportLayer transportLayer;
    private NetworkReceive netInBuffer;
    private NetworkSend netOutBuffer;
    private SaslState saslState = SaslState.INITIAL;

    public SaslClientAuthenticator(String node, Subject subject, String servicePrincipal, String host) throws IOException {
        this.node = node;
        this.subject = subject;
        this.host = host;
        this.servicePrincipal = servicePrincipal;
    }

    @Override
    public void configure(TransportLayer transportLayer, PrincipalBuilder principalBuilder, Map<String, ?> configs) throws KafkaException {
        try {
            this.transportLayer = transportLayer;
            Principal clientPrincipal = this.subject.getPrincipals().iterator().next();
            this.clientPrincipalName = clientPrincipal.getName();
            this.saslClient = this.createSaslClient();
        }
        catch (Exception e) {
            throw new KafkaException("Failed to configure SaslClientAuthenticator", e);
        }
    }

    private SaslClient createSaslClient() {
        try {
            return Subject.doAs(this.subject, new PrivilegedExceptionAction<SaslClient>(){

                @Override
                public SaslClient run() throws SaslException {
                    Object[] mechs = new String[]{"GSSAPI"};
                    LOG.debug("Creating SaslClient: client={};service={};serviceHostname={};mechs={}", new Object[]{SaslClientAuthenticator.this.clientPrincipalName, SaslClientAuthenticator.this.servicePrincipal, SaslClientAuthenticator.this.host, Arrays.toString(mechs)});
                    return Sasl.createSaslClient((String[])mechs, SaslClientAuthenticator.this.clientPrincipalName, SaslClientAuthenticator.this.servicePrincipal, SaslClientAuthenticator.this.host, null, new ClientCallbackHandler());
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new KafkaException("Failed to create SaslClient", e.getCause());
        }
    }

    @Override
    public void authenticate() throws IOException {
        if (this.netOutBuffer != null && !this.flushNetOutBufferAndUpdateInterestOps()) {
            return;
        }
        switch (this.saslState) {
            case INITIAL: {
                this.sendSaslToken(new byte[0]);
                this.saslState = SaslState.INTERMEDIATE;
                break;
            }
            case INTERMEDIATE: {
                if (this.netInBuffer == null) {
                    this.netInBuffer = new NetworkReceive(this.node);
                }
                this.netInBuffer.readFrom(this.transportLayer);
                if (this.netInBuffer.complete()) {
                    this.netInBuffer.payload().rewind();
                    byte[] serverToken = new byte[this.netInBuffer.payload().remaining()];
                    this.netInBuffer.payload().get(serverToken, 0, serverToken.length);
                    this.netInBuffer = null;
                    this.sendSaslToken(serverToken);
                }
                if (!this.saslClient.isComplete()) break;
                this.saslState = SaslState.COMPLETE;
                this.transportLayer.removeInterestOps(4);
                break;
            }
            case COMPLETE: {
                break;
            }
            case FAILED: {
                throw new IOException("SASL handshake failed");
            }
        }
    }

    private void sendSaslToken(byte[] serverToken) throws IOException {
        if (!this.saslClient.isComplete()) {
            try {
                byte[] saslToken = this.createSaslToken(serverToken);
                if (saslToken != null) {
                    this.netOutBuffer = new NetworkSend(this.node, ByteBuffer.wrap(saslToken));
                    this.flushNetOutBufferAndUpdateInterestOps();
                }
            }
            catch (IOException e) {
                this.saslState = SaslState.FAILED;
                throw e;
            }
        }
    }

    private boolean flushNetOutBufferAndUpdateInterestOps() throws IOException {
        boolean flushedCompletely = this.flushNetOutBuffer();
        if (flushedCompletely) {
            this.transportLayer.removeInterestOps(4);
        } else {
            this.transportLayer.addInterestOps(4);
        }
        return flushedCompletely;
    }

    @Override
    public Principal principal() {
        return new KafkaPrincipal("User", this.clientPrincipalName);
    }

    @Override
    public boolean complete() {
        return this.saslState == SaslState.COMPLETE;
    }

    @Override
    public void close() throws IOException {
        this.saslClient.dispose();
    }

    private byte[] createSaslToken(final byte[] saslToken) throws SaslException {
        if (saslToken == null) {
            throw new SaslException("Error authenticating with the Kafka Broker: received a `null` saslToken.");
        }
        try {
            return Subject.doAs(this.subject, new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws SaslException {
                    return SaslClientAuthenticator.this.saslClient.evaluateChallenge(saslToken);
                }
            });
        }
        catch (PrivilegedActionException e) {
            String error = "An error: (" + e + ") occurred when evaluating SASL token received from the Kafka Broker.";
            String unknownServerErrorText = "(Mechanism level: Server not found in Kerberos database (7) - UNKNOWN_SERVER)";
            if (e.toString().indexOf("(Mechanism level: Server not found in Kerberos database (7) - UNKNOWN_SERVER)") > -1) {
                error = error + " This may be caused by Java's being unable to resolve the Kafka Broker's hostname correctly. You may want to try to adding '-Dsun.net.spi.nameservice.provider.1=dns,sun' to your client's JVMFLAGS environment. Users must configure FQDN of kafka brokers when authenticating using SASL and `socketChannel.socket().getInetAddress().getHostName()` must match the hostname in `principal/hostname@realm`";
            }
            error = error + " Kafka Client will go to AUTH_FAILED state.";
            throw new SaslException(error, e.getCause());
        }
    }

    private boolean flushNetOutBuffer() throws IOException {
        if (!this.netOutBuffer.completed()) {
            this.netOutBuffer.writeTo(this.transportLayer);
        }
        return this.netOutBuffer.completed();
    }

    public static class ClientCallbackHandler
    implements CallbackHandler {
        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(nc.getDefaultName());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    throw new UnsupportedCallbackException(callback, "Could not login: the client is being asked for a password, but the Kafka client code does not currently support obtaining a password from the user. Make sure -Djava.security.auth.login.config property passed to JVM and the client is configured to use a ticket cache (using the JAAS configuration setting 'useTicketCache=true)'. Make sure you are using FQDN of the Kafka broker you are trying to connect to.");
                }
                if (callback instanceof RealmCallback) {
                    RealmCallback rc = (RealmCallback)callback;
                    rc.setText(rc.getDefaultText());
                    continue;
                }
                if (callback instanceof AuthorizeCallback) {
                    AuthorizeCallback ac = (AuthorizeCallback)callback;
                    String authId = ac.getAuthenticationID();
                    String authzId = ac.getAuthorizationID();
                    ac.setAuthorized(authId.equals(authzId));
                    if (!ac.isAuthorized()) continue;
                    ac.setAuthorizedID(authzId);
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL ClientCallback");
            }
        }
    }

    public static enum SaslState {
        INITIAL,
        INTERMEDIATE,
        COMPLETE,
        FAILED;

    }
}

