/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka09.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.requests.StopReplicaResponse;

public class StopReplicaRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.STOP_REPLICA.id);
    private static final String CONTROLLER_ID_KEY_NAME = "controller_id";
    private static final String CONTROLLER_EPOCH_KEY_NAME = "controller_epoch";
    private static final String DELETE_PARTITIONS_KEY_NAME = "delete_partitions";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITION_KEY_NAME = "partition";
    private final int controllerId;
    private final int controllerEpoch;
    private final boolean deletePartitions;
    private final Set<TopicPartition> partitions;

    public StopReplicaRequest(int controllerId, int controllerEpoch, boolean deletePartitions, Set<TopicPartition> partitions) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set(CONTROLLER_ID_KEY_NAME, (Object)controllerId);
        this.struct.set(CONTROLLER_EPOCH_KEY_NAME, (Object)controllerEpoch);
        this.struct.set(DELETE_PARTITIONS_KEY_NAME, (Object)(deletePartitions ? (byte)1 : 0));
        ArrayList<Struct> partitionDatas = new ArrayList<Struct>(partitions.size());
        for (TopicPartition partition : partitions) {
            Struct partitionData = this.struct.instance(PARTITIONS_KEY_NAME);
            partitionData.set(TOPIC_KEY_NAME, (Object)partition.topic());
            partitionData.set(PARTITION_KEY_NAME, (Object)partition.partition());
            partitionDatas.add(partitionData);
        }
        this.struct.set(PARTITIONS_KEY_NAME, (Object)partitionDatas.toArray());
        this.controllerId = controllerId;
        this.controllerEpoch = controllerEpoch;
        this.deletePartitions = deletePartitions;
        this.partitions = partitions;
    }

    public StopReplicaRequest(Struct struct) {
        super(struct);
        this.partitions = new HashSet<TopicPartition>();
        for (Object partitionDataObj : struct.getArray(PARTITIONS_KEY_NAME)) {
            Struct partitionData = (Struct)partitionDataObj;
            String topic = partitionData.getString(TOPIC_KEY_NAME);
            int partition = partitionData.getInt(PARTITION_KEY_NAME);
            this.partitions.add(new TopicPartition(topic, partition));
        }
        this.controllerId = struct.getInt(CONTROLLER_ID_KEY_NAME);
        this.controllerEpoch = struct.getInt(CONTROLLER_EPOCH_KEY_NAME);
        this.deletePartitions = (Byte)struct.get(DELETE_PARTITIONS_KEY_NAME) != 0;
    }

    @Override
    public AbstractRequestResponse getErrorResponse(int versionId, Throwable e) {
        HashMap<TopicPartition, Short> responses = new HashMap<TopicPartition, Short>(this.partitions.size());
        for (TopicPartition partition : this.partitions) {
            responses.put(partition, Errors.forException(e).code());
        }
        switch (versionId) {
            case 0: {
                return new StopReplicaResponse(Errors.NONE.code(), responses);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.STOP_REPLICA.id)));
    }

    public int controllerId() {
        return this.controllerId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public boolean deletePartitions() {
        return this.deletePartitions;
    }

    public Set<TopicPartition> partitions() {
        return this.partitions;
    }

    public static StopReplicaRequest parse(ByteBuffer buffer, int versionId) {
        return new StopReplicaRequest(ProtoUtils.parseRequest(ApiKeys.STOP_REPLICA.id, versionId, buffer));
    }

    public static StopReplicaRequest parse(ByteBuffer buffer) {
        return new StopReplicaRequest((Struct)CURRENT_SCHEMA.read(buffer));
    }
}

