/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka09.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.requests.ListGroupsResponse;

public class ListGroupsRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.LIST_GROUPS.id);

    public ListGroupsRequest() {
        super(new Struct(CURRENT_SCHEMA));
    }

    public ListGroupsRequest(Struct struct) {
        super(struct);
    }

    @Override
    public AbstractRequestResponse getErrorResponse(int versionId, Throwable e) {
        switch (versionId) {
            case 0: {
                short errorCode = Errors.forException(e).code();
                return new ListGroupsResponse(errorCode, Collections.emptyList());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.LIST_GROUPS.id)));
    }

    public static ListGroupsRequest parse(ByteBuffer buffer, int versionId) {
        return new ListGroupsRequest(ProtoUtils.parseRequest(ApiKeys.LIST_GROUPS.id, versionId, buffer));
    }

    public static ListGroupsRequest parse(ByteBuffer buffer) {
        return new ListGroupsRequest((Struct)CURRENT_SCHEMA.read(buffer));
    }
}

