/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka09.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.Node;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.requests.AbstractRequestResponse;

public class GroupCoordinatorResponse
extends AbstractRequestResponse {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentResponseSchema(ApiKeys.GROUP_COORDINATOR.id);
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private static final String COORDINATOR_KEY_NAME = "coordinator";
    private static final String NODE_ID_KEY_NAME = "node_id";
    private static final String HOST_KEY_NAME = "host";
    private static final String PORT_KEY_NAME = "port";
    private final short errorCode;
    private final Node node;

    public GroupCoordinatorResponse(short errorCode, Node node) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set(ERROR_CODE_KEY_NAME, (Object)errorCode);
        Struct coordinator = this.struct.instance(COORDINATOR_KEY_NAME);
        coordinator.set(NODE_ID_KEY_NAME, (Object)node.id());
        coordinator.set(HOST_KEY_NAME, (Object)node.host());
        coordinator.set(PORT_KEY_NAME, (Object)node.port());
        this.struct.set(COORDINATOR_KEY_NAME, (Object)coordinator);
        this.errorCode = errorCode;
        this.node = node;
    }

    public GroupCoordinatorResponse(Struct struct) {
        super(struct);
        this.errorCode = struct.getShort(ERROR_CODE_KEY_NAME);
        Struct broker = (Struct)struct.get(COORDINATOR_KEY_NAME);
        int nodeId = broker.getInt(NODE_ID_KEY_NAME);
        String host = broker.getString(HOST_KEY_NAME);
        int port = broker.getInt(PORT_KEY_NAME);
        this.node = new Node(nodeId, host, port);
    }

    public short errorCode() {
        return this.errorCode;
    }

    public Node node() {
        return this.node;
    }

    public static GroupCoordinatorResponse parse(ByteBuffer buffer) {
        return new GroupCoordinatorResponse((Struct)CURRENT_SCHEMA.read(buffer));
    }
}

