/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka09.shaded.org.apache.kafka.common.protocol;

import org.apache.flink.kafka09.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.protocol.types.Type;

public class Protocol {
    public static final Schema REQUEST_HEADER = new Schema(new Field("api_key", Type.INT16, "The id of the request type."), new Field("api_version", Type.INT16, "The version of the API."), new Field("correlation_id", Type.INT32, "A user-supplied integer value that will be passed back with the response"), new Field("client_id", Type.STRING, "A user specified identifier for the client making the request."));
    public static final Schema RESPONSE_HEADER = new Schema(new Field("correlation_id", Type.INT32, "The user-supplied value passed in with the request"));
    public static final Schema METADATA_REQUEST_V0 = new Schema(new Field("topics", new ArrayOf(Type.STRING), "An array of topics to fetch metadata for. If no topics are specified fetch metadata for all topics."));
    public static final Schema BROKER = new Schema(new Field("node_id", Type.INT32, "The broker id."), new Field("host", Type.STRING, "The hostname of the broker."), new Field("port", Type.INT32, "The port on which the broker accepts requests."));
    public static final Schema PARTITION_METADATA_V0 = new Schema(new Field("partition_error_code", Type.INT16, "The error code for the partition, if any."), new Field("partition_id", Type.INT32, "The id of the partition."), new Field("leader", Type.INT32, "The id of the broker acting as leader for this partition."), new Field("replicas", new ArrayOf(Type.INT32), "The set of all nodes that host this partition."), new Field("isr", new ArrayOf(Type.INT32), "The set of nodes that are in sync with the leader for this partition."));
    public static final Schema TOPIC_METADATA_V0 = new Schema(new Field("topic_error_code", Type.INT16, "The error code for the given topic."), new Field("topic", Type.STRING, "The name of the topic"), new Field("partition_metadata", new ArrayOf(PARTITION_METADATA_V0), "Metadata for each partition of the topic."));
    public static final Schema METADATA_RESPONSE_V0 = new Schema(new Field("brokers", new ArrayOf(BROKER), "Host and port information for all brokers."), new Field("topic_metadata", new ArrayOf(TOPIC_METADATA_V0)));
    public static final Schema[] METADATA_REQUEST = new Schema[]{METADATA_REQUEST_V0};
    public static final Schema[] METADATA_RESPONSE = new Schema[]{METADATA_RESPONSE_V0};
    public static final Schema TOPIC_PRODUCE_DATA_V0 = new Schema(new Field("topic", Type.STRING), new Field("data", new ArrayOf(new Schema(new Field("partition", Type.INT32), new Field("record_set", Type.BYTES)))));
    public static final Schema PRODUCE_REQUEST_V0 = new Schema(new Field("acks", Type.INT16, "The number of nodes that should replicate the produce before returning. -1 indicates the full ISR."), new Field("timeout", Type.INT32, "The time to await a response in ms."), new Field("topic_data", new ArrayOf(TOPIC_PRODUCE_DATA_V0)));
    public static final Schema PRODUCE_RESPONSE_V0 = new Schema(new Field("responses", new ArrayOf(new Schema(new Field("topic", Type.STRING), new Field("partition_responses", new ArrayOf(new Schema(new Field("partition", Type.INT32), new Field("error_code", Type.INT16), new Field("base_offset", Type.INT64))))))));
    public static final Schema PRODUCE_REQUEST_V1 = PRODUCE_REQUEST_V0;
    public static final Schema PRODUCE_RESPONSE_V1 = new Schema(new Field("responses", new ArrayOf(new Schema(new Field("topic", Type.STRING), new Field("partition_responses", new ArrayOf(new Schema(new Field("partition", Type.INT32), new Field("error_code", Type.INT16), new Field("base_offset", Type.INT64))))))), new Field("throttle_time_ms", Type.INT32, "Duration in milliseconds for which the request was throttled due to quota violation. (Zero if the request did not violate any quota.)", 0));
    public static final Schema[] PRODUCE_REQUEST = new Schema[]{PRODUCE_REQUEST_V0, PRODUCE_REQUEST_V1};
    public static final Schema[] PRODUCE_RESPONSE = new Schema[]{PRODUCE_RESPONSE_V0, PRODUCE_RESPONSE_V1};
    public static final Schema OFFSET_COMMIT_REQUEST_PARTITION_V0 = new Schema(new Field("partition", Type.INT32, "Topic partition id."), new Field("offset", Type.INT64, "Message offset to be committed."), new Field("metadata", Type.STRING, "Any associated metadata the client wants to keep."));
    public static final Schema OFFSET_COMMIT_REQUEST_PARTITION_V1 = new Schema(new Field("partition", Type.INT32, "Topic partition id."), new Field("offset", Type.INT64, "Message offset to be committed."), new Field("timestamp", Type.INT64, "Timestamp of the commit"), new Field("metadata", Type.STRING, "Any associated metadata the client wants to keep."));
    public static final Schema OFFSET_COMMIT_REQUEST_PARTITION_V2 = new Schema(new Field("partition", Type.INT32, "Topic partition id."), new Field("offset", Type.INT64, "Message offset to be committed."), new Field("metadata", Type.STRING, "Any associated metadata the client wants to keep."));
    public static final Schema OFFSET_COMMIT_REQUEST_TOPIC_V0 = new Schema(new Field("topic", Type.STRING, "Topic to commit."), new Field("partitions", new ArrayOf(OFFSET_COMMIT_REQUEST_PARTITION_V0), "Partitions to commit offsets."));
    public static final Schema OFFSET_COMMIT_REQUEST_TOPIC_V1 = new Schema(new Field("topic", Type.STRING, "Topic to commit."), new Field("partitions", new ArrayOf(OFFSET_COMMIT_REQUEST_PARTITION_V1), "Partitions to commit offsets."));
    public static final Schema OFFSET_COMMIT_REQUEST_TOPIC_V2 = new Schema(new Field("topic", Type.STRING, "Topic to commit."), new Field("partitions", new ArrayOf(OFFSET_COMMIT_REQUEST_PARTITION_V2), "Partitions to commit offsets."));
    public static final Schema OFFSET_COMMIT_REQUEST_V0 = new Schema(new Field("group_id", Type.STRING, "The group id."), new Field("topics", new ArrayOf(OFFSET_COMMIT_REQUEST_TOPIC_V0), "Topics to commit offsets."));
    public static final Schema OFFSET_COMMIT_REQUEST_V1 = new Schema(new Field("group_id", Type.STRING, "The group id."), new Field("group_generation_id", Type.INT32, "The generation of the group."), new Field("member_id", Type.STRING, "The member id assigned by the group coordinator."), new Field("topics", new ArrayOf(OFFSET_COMMIT_REQUEST_TOPIC_V1), "Topics to commit offsets."));
    public static final Schema OFFSET_COMMIT_REQUEST_V2 = new Schema(new Field("group_id", Type.STRING, "The group id."), new Field("group_generation_id", Type.INT32, "The generation of the consumer group."), new Field("member_id", Type.STRING, "The consumer id assigned by the group coordinator."), new Field("retention_time", Type.INT64, "Time period in ms to retain the offset."), new Field("topics", new ArrayOf(OFFSET_COMMIT_REQUEST_TOPIC_V2), "Topics to commit offsets."));
    public static final Schema OFFSET_COMMIT_RESPONSE_PARTITION_V0 = new Schema(new Field("partition", Type.INT32, "Topic partition id."), new Field("error_code", Type.INT16));
    public static final Schema OFFSET_COMMIT_RESPONSE_TOPIC_V0 = new Schema(new Field("topic", Type.STRING), new Field("partition_responses", new ArrayOf(OFFSET_COMMIT_RESPONSE_PARTITION_V0)));
    public static final Schema OFFSET_COMMIT_RESPONSE_V0 = new Schema(new Field("responses", new ArrayOf(OFFSET_COMMIT_RESPONSE_TOPIC_V0)));
    public static final Schema[] OFFSET_COMMIT_REQUEST = new Schema[]{OFFSET_COMMIT_REQUEST_V0, OFFSET_COMMIT_REQUEST_V1, OFFSET_COMMIT_REQUEST_V2};
    public static final Schema OFFSET_COMMIT_RESPONSE_V1 = OFFSET_COMMIT_RESPONSE_V0;
    public static final Schema OFFSET_COMMIT_RESPONSE_V2 = OFFSET_COMMIT_RESPONSE_V0;
    public static final Schema[] OFFSET_COMMIT_RESPONSE = new Schema[]{OFFSET_COMMIT_RESPONSE_V0, OFFSET_COMMIT_RESPONSE_V1, OFFSET_COMMIT_RESPONSE_V2};
    public static final Schema OFFSET_FETCH_REQUEST_PARTITION_V0 = new Schema(new Field("partition", Type.INT32, "Topic partition id."));
    public static final Schema OFFSET_FETCH_REQUEST_TOPIC_V0 = new Schema(new Field("topic", Type.STRING, "Topic to fetch offset."), new Field("partitions", new ArrayOf(OFFSET_FETCH_REQUEST_PARTITION_V0), "Partitions to fetch offsets."));
    public static final Schema OFFSET_FETCH_REQUEST_V0 = new Schema(new Field("group_id", Type.STRING, "The consumer group id."), new Field("topics", new ArrayOf(OFFSET_FETCH_REQUEST_TOPIC_V0), "Topics to fetch offsets."));
    public static final Schema OFFSET_FETCH_RESPONSE_PARTITION_V0 = new Schema(new Field("partition", Type.INT32, "Topic partition id."), new Field("offset", Type.INT64, "Last committed message offset."), new Field("metadata", Type.STRING, "Any associated metadata the client wants to keep."), new Field("error_code", Type.INT16));
    public static final Schema OFFSET_FETCH_RESPONSE_TOPIC_V0 = new Schema(new Field("topic", Type.STRING), new Field("partition_responses", new ArrayOf(OFFSET_FETCH_RESPONSE_PARTITION_V0)));
    public static final Schema OFFSET_FETCH_RESPONSE_V0 = new Schema(new Field("responses", new ArrayOf(OFFSET_FETCH_RESPONSE_TOPIC_V0)));
    public static final Schema OFFSET_FETCH_REQUEST_V1 = OFFSET_FETCH_REQUEST_V0;
    public static final Schema OFFSET_FETCH_RESPONSE_V1 = OFFSET_FETCH_RESPONSE_V0;
    public static final Schema[] OFFSET_FETCH_REQUEST = new Schema[]{OFFSET_FETCH_REQUEST_V0, OFFSET_FETCH_REQUEST_V1};
    public static final Schema[] OFFSET_FETCH_RESPONSE = new Schema[]{OFFSET_FETCH_RESPONSE_V0, OFFSET_FETCH_RESPONSE_V1};
    public static final Schema LIST_OFFSET_REQUEST_PARTITION_V0 = new Schema(new Field("partition", Type.INT32, "Topic partition id."), new Field("timestamp", Type.INT64, "Timestamp."), new Field("max_num_offsets", Type.INT32, "Maximum offsets to return."));
    public static final Schema LIST_OFFSET_REQUEST_TOPIC_V0 = new Schema(new Field("topic", Type.STRING, "Topic to list offset."), new Field("partitions", new ArrayOf(LIST_OFFSET_REQUEST_PARTITION_V0), "Partitions to list offset."));
    public static final Schema LIST_OFFSET_REQUEST_V0 = new Schema(new Field("replica_id", Type.INT32, "Broker id of the follower. For normal consumers, use -1."), new Field("topics", new ArrayOf(LIST_OFFSET_REQUEST_TOPIC_V0), "Topics to list offsets."));
    public static final Schema LIST_OFFSET_RESPONSE_PARTITION_V0 = new Schema(new Field("partition", Type.INT32, "Topic partition id."), new Field("error_code", Type.INT16), new Field("offsets", new ArrayOf(Type.INT64), "A list of offsets."));
    public static final Schema LIST_OFFSET_RESPONSE_TOPIC_V0 = new Schema(new Field("topic", Type.STRING), new Field("partition_responses", new ArrayOf(LIST_OFFSET_RESPONSE_PARTITION_V0)));
    public static final Schema LIST_OFFSET_RESPONSE_V0 = new Schema(new Field("responses", new ArrayOf(LIST_OFFSET_RESPONSE_TOPIC_V0)));
    public static final Schema[] LIST_OFFSET_REQUEST = new Schema[]{LIST_OFFSET_REQUEST_V0};
    public static final Schema[] LIST_OFFSET_RESPONSE = new Schema[]{LIST_OFFSET_RESPONSE_V0};
    public static final Schema FETCH_REQUEST_PARTITION_V0 = new Schema(new Field("partition", Type.INT32, "Topic partition id."), new Field("fetch_offset", Type.INT64, "Message offset."), new Field("max_bytes", Type.INT32, "Maximum bytes to fetch."));
    public static final Schema FETCH_REQUEST_TOPIC_V0 = new Schema(new Field("topic", Type.STRING, "Topic to fetch."), new Field("partitions", new ArrayOf(FETCH_REQUEST_PARTITION_V0), "Partitions to fetch."));
    public static final Schema FETCH_REQUEST_V0;
    public static final Schema FETCH_REQUEST_V1;
    public static final Schema FETCH_RESPONSE_PARTITION_V0;
    public static final Schema FETCH_RESPONSE_TOPIC_V0;
    public static final Schema FETCH_RESPONSE_V0;
    public static final Schema FETCH_RESPONSE_V1;
    public static final Schema[] FETCH_REQUEST;
    public static final Schema[] FETCH_RESPONSE;
    public static final Schema LIST_GROUPS_REQUEST_V0;
    public static final Schema LIST_GROUPS_RESPONSE_GROUP_V0;
    public static final Schema LIST_GROUPS_RESPONSE_V0;
    public static final Schema[] LIST_GROUPS_REQUEST;
    public static final Schema[] LIST_GROUPS_RESPONSE;
    public static final Schema DESCRIBE_GROUPS_REQUEST_V0;
    public static final Schema DESCRIBE_GROUPS_RESPONSE_MEMBER_V0;
    public static final Schema DESCRIBE_GROUPS_RESPONSE_GROUP_METADATA_V0;
    public static final Schema DESCRIBE_GROUPS_RESPONSE_V0;
    public static final Schema[] DESCRIBE_GROUPS_REQUEST;
    public static final Schema[] DESCRIBE_GROUPS_RESPONSE;
    public static final Schema GROUP_COORDINATOR_REQUEST_V0;
    public static final Schema GROUP_COORDINATOR_RESPONSE_V0;
    public static final Schema[] GROUP_COORDINATOR_REQUEST;
    public static final Schema[] GROUP_COORDINATOR_RESPONSE;
    public static final Schema CONTROLLED_SHUTDOWN_REQUEST_V1;
    public static final Schema CONTROLLED_SHUTDOWN_PARTITION_V1;
    public static final Schema CONTROLLED_SHUTDOWN_RESPONSE_V1;
    public static final Schema[] CONTROLLED_SHUTDOWN_REQUEST;
    public static final Schema[] CONTROLLED_SHUTDOWN_RESPONSE;
    public static final Schema JOIN_GROUP_REQUEST_PROTOCOL_V0;
    public static final Schema JOIN_GROUP_REQUEST_V0;
    public static final Schema JOIN_GROUP_RESPONSE_MEMBER_V0;
    public static final Schema JOIN_GROUP_RESPONSE_V0;
    public static final Schema[] JOIN_GROUP_REQUEST;
    public static final Schema[] JOIN_GROUP_RESPONSE;
    public static final Schema SYNC_GROUP_REQUEST_MEMBER_V0;
    public static final Schema SYNC_GROUP_REQUEST_V0;
    public static final Schema SYNC_GROUP_RESPONSE_V0;
    public static final Schema[] SYNC_GROUP_REQUEST;
    public static final Schema[] SYNC_GROUP_RESPONSE;
    public static final Schema HEARTBEAT_REQUEST_V0;
    public static final Schema HEARTBEAT_RESPONSE_V0;
    public static final Schema[] HEARTBEAT_REQUEST;
    public static final Schema[] HEARTBEAT_RESPONSE;
    public static final Schema LEAVE_GROUP_REQUEST_V0;
    public static final Schema LEAVE_GROUP_RESPONSE_V0;
    public static final Schema[] LEAVE_GROUP_REQUEST;
    public static final Schema[] LEAVE_GROUP_RESPONSE;
    public static final Schema LEADER_AND_ISR_REQUEST_PARTITION_STATE_V0;
    public static final Schema LEADER_AND_ISR_REQUEST_LIVE_LEADER_V0;
    public static final Schema LEADER_AND_ISR_REQUEST_V0;
    public static final Schema LEADER_AND_ISR_RESPONSE_PARTITION_V0;
    public static final Schema LEADER_AND_ISR_RESPONSE_V0;
    public static final Schema[] LEADER_AND_ISR_REQUEST;
    public static final Schema[] LEADER_AND_ISR_RESPONSE;
    public static final Schema STOP_REPLICA_REQUEST_PARTITION_V0;
    public static final Schema STOP_REPLICA_REQUEST_V0;
    public static final Schema STOP_REPLICA_RESPONSE_PARTITION_V0;
    public static final Schema STOP_REPLICA_RESPONSE_V0;
    public static final Schema[] STOP_REPLICA_REQUEST;
    public static final Schema[] STOP_REPLICA_RESPONSE;
    public static final Schema UPDATE_METADATA_REQUEST_PARTITION_STATE_V0;
    public static final Schema UPDATE_METADATA_REQUEST_BROKER_V0;
    public static final Schema UPDATE_METADATA_REQUEST_V0;
    public static final Schema UPDATE_METADATA_RESPONSE_V0;
    public static final Schema UPDATE_METADATA_REQUEST_PARTITION_STATE_V1;
    public static final Schema UPDATE_METADATA_REQUEST_END_POINT_V1;
    public static final Schema UPDATE_METADATA_REQUEST_BROKER_V1;
    public static final Schema UPDATE_METADATA_REQUEST_V1;
    public static final Schema UPDATE_METADATA_RESPONSE_V1;
    public static final Schema[] UPDATE_METADATA_REQUEST;
    public static final Schema[] UPDATE_METADATA_RESPONSE;
    public static final Schema[][] REQUESTS;
    public static final Schema[][] RESPONSES;
    public static final short[] CURR_VERSION;

    static {
        FETCH_REQUEST_V1 = FETCH_REQUEST_V0 = new Schema(new Field("replica_id", Type.INT32, "Broker id of the follower. For normal consumers, use -1."), new Field("max_wait_time", Type.INT32, "Maximum time in ms to wait for the response."), new Field("min_bytes", Type.INT32, "Minimum bytes to accumulate in the response."), new Field("topics", new ArrayOf(FETCH_REQUEST_TOPIC_V0), "Topics to fetch."));
        FETCH_RESPONSE_PARTITION_V0 = new Schema(new Field("partition", Type.INT32, "Topic partition id."), new Field("error_code", Type.INT16), new Field("high_watermark", Type.INT64, "Last committed offset."), new Field("record_set", Type.BYTES));
        FETCH_RESPONSE_TOPIC_V0 = new Schema(new Field("topic", Type.STRING), new Field("partition_responses", new ArrayOf(FETCH_RESPONSE_PARTITION_V0)));
        FETCH_RESPONSE_V0 = new Schema(new Field("responses", new ArrayOf(FETCH_RESPONSE_TOPIC_V0)));
        FETCH_RESPONSE_V1 = new Schema(new Field("throttle_time_ms", Type.INT32, "Duration in milliseconds for which the request was throttled due to quota violation. (Zero if the request did not violate any quota.)", 0), new Field("responses", new ArrayOf(FETCH_RESPONSE_TOPIC_V0)));
        FETCH_REQUEST = new Schema[]{FETCH_REQUEST_V0, FETCH_REQUEST_V1};
        FETCH_RESPONSE = new Schema[]{FETCH_RESPONSE_V0, FETCH_RESPONSE_V1};
        LIST_GROUPS_REQUEST_V0 = new Schema(new Field[0]);
        LIST_GROUPS_RESPONSE_GROUP_V0 = new Schema(new Field("group_id", Type.STRING), new Field("protocol_type", Type.STRING));
        LIST_GROUPS_RESPONSE_V0 = new Schema(new Field("error_code", Type.INT16), new Field("groups", new ArrayOf(LIST_GROUPS_RESPONSE_GROUP_V0)));
        LIST_GROUPS_REQUEST = new Schema[]{LIST_GROUPS_REQUEST_V0};
        LIST_GROUPS_RESPONSE = new Schema[]{LIST_GROUPS_RESPONSE_V0};
        DESCRIBE_GROUPS_REQUEST_V0 = new Schema(new Field("group_ids", new ArrayOf(Type.STRING), "List of groupIds to request metadata for (an empty groupId array will return empty group metadata)."));
        DESCRIBE_GROUPS_RESPONSE_MEMBER_V0 = new Schema(new Field("member_id", Type.STRING, "The memberId assigned by the coordinator"), new Field("client_id", Type.STRING, "The client id used in the member's latest join group request"), new Field("client_host", Type.STRING, "The client host used in the request session corresponding to the member's join group."), new Field("member_metadata", Type.BYTES, "The metadata corresponding to the current group protocol in use (will only be present if the group is stable)."), new Field("member_assignment", Type.BYTES, "The current assignment provided by the group leader (will only be present if the group is stable)."));
        DESCRIBE_GROUPS_RESPONSE_GROUP_METADATA_V0 = new Schema(new Field("error_code", Type.INT16), new Field("group_id", Type.STRING), new Field("state", Type.STRING, "The current state of the group (one of: Dead, Stable, AwaitingSync, or PreparingRebalance, or empty if there is no active group)"), new Field("protocol_type", Type.STRING, "The current group protocol type (will be empty if the there is no active group)"), new Field("protocol", Type.STRING, "The current group protocol (only provided if the group is Stable)"), new Field("members", new ArrayOf(DESCRIBE_GROUPS_RESPONSE_MEMBER_V0), "Current group members (only provided if the group is not Dead)"));
        DESCRIBE_GROUPS_RESPONSE_V0 = new Schema(new Field("groups", new ArrayOf(DESCRIBE_GROUPS_RESPONSE_GROUP_METADATA_V0)));
        DESCRIBE_GROUPS_REQUEST = new Schema[]{DESCRIBE_GROUPS_REQUEST_V0};
        DESCRIBE_GROUPS_RESPONSE = new Schema[]{DESCRIBE_GROUPS_RESPONSE_V0};
        GROUP_COORDINATOR_REQUEST_V0 = new Schema(new Field("group_id", Type.STRING, "The unique group id."));
        GROUP_COORDINATOR_RESPONSE_V0 = new Schema(new Field("error_code", Type.INT16), new Field("coordinator", BROKER, "Host and port information for the coordinator for a consumer group."));
        GROUP_COORDINATOR_REQUEST = new Schema[]{GROUP_COORDINATOR_REQUEST_V0};
        GROUP_COORDINATOR_RESPONSE = new Schema[]{GROUP_COORDINATOR_RESPONSE_V0};
        CONTROLLED_SHUTDOWN_REQUEST_V1 = new Schema(new Field("broker_id", Type.INT32, "The id of the broker for which controlled shutdown has been requested."));
        CONTROLLED_SHUTDOWN_PARTITION_V1 = new Schema(new Field("topic", Type.STRING), new Field("partition", Type.INT32, "Topic partition id."));
        CONTROLLED_SHUTDOWN_RESPONSE_V1 = new Schema(new Field("error_code", Type.INT16), new Field("partitions_remaining", new ArrayOf(CONTROLLED_SHUTDOWN_PARTITION_V1), "The partitions that the broker still leads."));
        CONTROLLED_SHUTDOWN_REQUEST = new Schema[]{null, CONTROLLED_SHUTDOWN_REQUEST_V1};
        CONTROLLED_SHUTDOWN_RESPONSE = new Schema[]{null, CONTROLLED_SHUTDOWN_RESPONSE_V1};
        JOIN_GROUP_REQUEST_PROTOCOL_V0 = new Schema(new Field("protocol_name", Type.STRING), new Field("protocol_metadata", Type.BYTES));
        JOIN_GROUP_REQUEST_V0 = new Schema(new Field("group_id", Type.STRING, "The group id."), new Field("session_timeout", Type.INT32, "The coordinator considers the consumer dead if it receives no heartbeat after this timeout in ms."), new Field("member_id", Type.STRING, "The assigned consumer id or an empty string for a new consumer."), new Field("protocol_type", Type.STRING, "Unique name for class of protocols implemented by group"), new Field("group_protocols", new ArrayOf(JOIN_GROUP_REQUEST_PROTOCOL_V0), "List of protocols that the member supports"));
        JOIN_GROUP_RESPONSE_MEMBER_V0 = new Schema(new Field("member_id", Type.STRING), new Field("member_metadata", Type.BYTES));
        JOIN_GROUP_RESPONSE_V0 = new Schema(new Field("error_code", Type.INT16), new Field("generation_id", Type.INT32, "The generation of the consumer group."), new Field("group_protocol", Type.STRING, "The group protocol selected by the coordinator"), new Field("leader_id", Type.STRING, "The leader of the group"), new Field("member_id", Type.STRING, "The consumer id assigned by the group coordinator."), new Field("members", new ArrayOf(JOIN_GROUP_RESPONSE_MEMBER_V0)));
        JOIN_GROUP_REQUEST = new Schema[]{JOIN_GROUP_REQUEST_V0};
        JOIN_GROUP_RESPONSE = new Schema[]{JOIN_GROUP_RESPONSE_V0};
        SYNC_GROUP_REQUEST_MEMBER_V0 = new Schema(new Field("member_id", Type.STRING), new Field("member_assignment", Type.BYTES));
        SYNC_GROUP_REQUEST_V0 = new Schema(new Field("group_id", Type.STRING), new Field("generation_id", Type.INT32), new Field("member_id", Type.STRING), new Field("group_assignment", new ArrayOf(SYNC_GROUP_REQUEST_MEMBER_V0)));
        SYNC_GROUP_RESPONSE_V0 = new Schema(new Field("error_code", Type.INT16), new Field("member_assignment", Type.BYTES));
        SYNC_GROUP_REQUEST = new Schema[]{SYNC_GROUP_REQUEST_V0};
        SYNC_GROUP_RESPONSE = new Schema[]{SYNC_GROUP_RESPONSE_V0};
        HEARTBEAT_REQUEST_V0 = new Schema(new Field("group_id", Type.STRING, "The group id."), new Field("group_generation_id", Type.INT32, "The generation of the group."), new Field("member_id", Type.STRING, "The member id assigned by the group coordinator."));
        HEARTBEAT_RESPONSE_V0 = new Schema(new Field("error_code", Type.INT16));
        HEARTBEAT_REQUEST = new Schema[]{HEARTBEAT_REQUEST_V0};
        HEARTBEAT_RESPONSE = new Schema[]{HEARTBEAT_RESPONSE_V0};
        LEAVE_GROUP_REQUEST_V0 = new Schema(new Field("group_id", Type.STRING, "The group id."), new Field("member_id", Type.STRING, "The member id assigned by the group coordinator."));
        LEAVE_GROUP_RESPONSE_V0 = new Schema(new Field("error_code", Type.INT16));
        LEAVE_GROUP_REQUEST = new Schema[]{LEAVE_GROUP_REQUEST_V0};
        LEAVE_GROUP_RESPONSE = new Schema[]{LEAVE_GROUP_RESPONSE_V0};
        LEADER_AND_ISR_REQUEST_PARTITION_STATE_V0 = new Schema(new Field("topic", Type.STRING, "Topic name."), new Field("partition", Type.INT32, "Topic partition id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The broker id for the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr", new ArrayOf(Type.INT32), "The in sync replica ids."), new Field("zk_version", Type.INT32, "The ZK version."), new Field("replicas", new ArrayOf(Type.INT32), "The replica ids."));
        LEADER_AND_ISR_REQUEST_LIVE_LEADER_V0 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("host", Type.STRING, "The hostname of the broker."), new Field("port", Type.INT32, "The port on which the broker accepts requests."));
        LEADER_AND_ISR_REQUEST_V0 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("partition_states", new ArrayOf(LEADER_AND_ISR_REQUEST_PARTITION_STATE_V0)), new Field("live_leaders", new ArrayOf(LEADER_AND_ISR_REQUEST_LIVE_LEADER_V0)));
        LEADER_AND_ISR_RESPONSE_PARTITION_V0 = new Schema(new Field("topic", Type.STRING, "Topic name."), new Field("partition", Type.INT32, "Topic partition id."), new Field("error_code", Type.INT16, "Error code."));
        LEADER_AND_ISR_RESPONSE_V0 = new Schema(new Field("error_code", Type.INT16, "Error code."), new Field("partitions", new ArrayOf(LEADER_AND_ISR_RESPONSE_PARTITION_V0)));
        LEADER_AND_ISR_REQUEST = new Schema[]{LEADER_AND_ISR_REQUEST_V0};
        LEADER_AND_ISR_RESPONSE = new Schema[]{LEADER_AND_ISR_RESPONSE_V0};
        STOP_REPLICA_REQUEST_PARTITION_V0 = new Schema(new Field("topic", Type.STRING, "Topic name."), new Field("partition", Type.INT32, "Topic partition id."));
        STOP_REPLICA_REQUEST_V0 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("delete_partitions", Type.INT8, "Boolean which indicates if replica's partitions must be deleted."), new Field("partitions", new ArrayOf(STOP_REPLICA_REQUEST_PARTITION_V0)));
        STOP_REPLICA_RESPONSE_PARTITION_V0 = new Schema(new Field("topic", Type.STRING, "Topic name."), new Field("partition", Type.INT32, "Topic partition id."), new Field("error_code", Type.INT16, "Error code."));
        STOP_REPLICA_RESPONSE_V0 = new Schema(new Field("error_code", Type.INT16, "Error code."), new Field("partitions", new ArrayOf(STOP_REPLICA_RESPONSE_PARTITION_V0)));
        STOP_REPLICA_REQUEST = new Schema[]{STOP_REPLICA_REQUEST_V0};
        STOP_REPLICA_RESPONSE = new Schema[]{STOP_REPLICA_RESPONSE_V0};
        UPDATE_METADATA_REQUEST_PARTITION_STATE_V0 = LEADER_AND_ISR_REQUEST_PARTITION_STATE_V0;
        UPDATE_METADATA_REQUEST_BROKER_V0 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("host", Type.STRING, "The hostname of the broker."), new Field("port", Type.INT32, "The port on which the broker accepts requests."));
        UPDATE_METADATA_REQUEST_V0 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("partition_states", new ArrayOf(UPDATE_METADATA_REQUEST_PARTITION_STATE_V0)), new Field("live_brokers", new ArrayOf(UPDATE_METADATA_REQUEST_BROKER_V0)));
        UPDATE_METADATA_RESPONSE_V0 = new Schema(new Field("error_code", Type.INT16, "Error code."));
        UPDATE_METADATA_REQUEST_PARTITION_STATE_V1 = UPDATE_METADATA_REQUEST_PARTITION_STATE_V0;
        UPDATE_METADATA_REQUEST_END_POINT_V1 = new Schema(new Field("port", Type.INT32, "The port on which the broker accepts requests."), new Field("host", Type.STRING, "The hostname of the broker."), new Field("security_protocol_type", Type.INT16, "The security protocol type."));
        UPDATE_METADATA_REQUEST_BROKER_V1 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("end_points", new ArrayOf(UPDATE_METADATA_REQUEST_END_POINT_V1)));
        UPDATE_METADATA_REQUEST_V1 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("partition_states", new ArrayOf(UPDATE_METADATA_REQUEST_PARTITION_STATE_V1)), new Field("live_brokers", new ArrayOf(UPDATE_METADATA_REQUEST_BROKER_V1)));
        UPDATE_METADATA_RESPONSE_V1 = UPDATE_METADATA_RESPONSE_V0;
        UPDATE_METADATA_REQUEST = new Schema[]{UPDATE_METADATA_REQUEST_V0, UPDATE_METADATA_REQUEST_V1};
        UPDATE_METADATA_RESPONSE = new Schema[]{UPDATE_METADATA_RESPONSE_V0, UPDATE_METADATA_RESPONSE_V1};
        REQUESTS = new Schema[ApiKeys.MAX_API_KEY + 1][];
        RESPONSES = new Schema[ApiKeys.MAX_API_KEY + 1][];
        CURR_VERSION = new short[ApiKeys.MAX_API_KEY + 1];
        Protocol.REQUESTS[ApiKeys.PRODUCE.id] = PRODUCE_REQUEST;
        Protocol.REQUESTS[ApiKeys.FETCH.id] = FETCH_REQUEST;
        Protocol.REQUESTS[ApiKeys.LIST_OFFSETS.id] = LIST_OFFSET_REQUEST;
        Protocol.REQUESTS[ApiKeys.METADATA.id] = METADATA_REQUEST;
        Protocol.REQUESTS[ApiKeys.LEADER_AND_ISR.id] = LEADER_AND_ISR_REQUEST;
        Protocol.REQUESTS[ApiKeys.STOP_REPLICA.id] = STOP_REPLICA_REQUEST;
        Protocol.REQUESTS[ApiKeys.UPDATE_METADATA_KEY.id] = UPDATE_METADATA_REQUEST;
        Protocol.REQUESTS[ApiKeys.CONTROLLED_SHUTDOWN_KEY.id] = CONTROLLED_SHUTDOWN_REQUEST;
        Protocol.REQUESTS[ApiKeys.OFFSET_COMMIT.id] = OFFSET_COMMIT_REQUEST;
        Protocol.REQUESTS[ApiKeys.OFFSET_FETCH.id] = OFFSET_FETCH_REQUEST;
        Protocol.REQUESTS[ApiKeys.GROUP_COORDINATOR.id] = GROUP_COORDINATOR_REQUEST;
        Protocol.REQUESTS[ApiKeys.JOIN_GROUP.id] = JOIN_GROUP_REQUEST;
        Protocol.REQUESTS[ApiKeys.HEARTBEAT.id] = HEARTBEAT_REQUEST;
        Protocol.REQUESTS[ApiKeys.LEAVE_GROUP.id] = LEAVE_GROUP_REQUEST;
        Protocol.REQUESTS[ApiKeys.SYNC_GROUP.id] = SYNC_GROUP_REQUEST;
        Protocol.REQUESTS[ApiKeys.DESCRIBE_GROUPS.id] = DESCRIBE_GROUPS_REQUEST;
        Protocol.REQUESTS[ApiKeys.LIST_GROUPS.id] = LIST_GROUPS_REQUEST;
        Protocol.RESPONSES[ApiKeys.PRODUCE.id] = PRODUCE_RESPONSE;
        Protocol.RESPONSES[ApiKeys.FETCH.id] = FETCH_RESPONSE;
        Protocol.RESPONSES[ApiKeys.LIST_OFFSETS.id] = LIST_OFFSET_RESPONSE;
        Protocol.RESPONSES[ApiKeys.METADATA.id] = METADATA_RESPONSE;
        Protocol.RESPONSES[ApiKeys.LEADER_AND_ISR.id] = LEADER_AND_ISR_RESPONSE;
        Protocol.RESPONSES[ApiKeys.STOP_REPLICA.id] = STOP_REPLICA_RESPONSE;
        Protocol.RESPONSES[ApiKeys.UPDATE_METADATA_KEY.id] = UPDATE_METADATA_RESPONSE;
        Protocol.RESPONSES[ApiKeys.CONTROLLED_SHUTDOWN_KEY.id] = CONTROLLED_SHUTDOWN_RESPONSE;
        Protocol.RESPONSES[ApiKeys.OFFSET_COMMIT.id] = OFFSET_COMMIT_RESPONSE;
        Protocol.RESPONSES[ApiKeys.OFFSET_FETCH.id] = OFFSET_FETCH_RESPONSE;
        Protocol.RESPONSES[ApiKeys.GROUP_COORDINATOR.id] = GROUP_COORDINATOR_RESPONSE;
        Protocol.RESPONSES[ApiKeys.JOIN_GROUP.id] = JOIN_GROUP_RESPONSE;
        Protocol.RESPONSES[ApiKeys.HEARTBEAT.id] = HEARTBEAT_RESPONSE;
        Protocol.RESPONSES[ApiKeys.LEAVE_GROUP.id] = LEAVE_GROUP_RESPONSE;
        Protocol.RESPONSES[ApiKeys.SYNC_GROUP.id] = SYNC_GROUP_RESPONSE;
        Protocol.RESPONSES[ApiKeys.DESCRIBE_GROUPS.id] = DESCRIBE_GROUPS_RESPONSE;
        Protocol.RESPONSES[ApiKeys.LIST_GROUPS.id] = LIST_GROUPS_RESPONSE;
        for (ApiKeys api : ApiKeys.values()) {
            Protocol.CURR_VERSION[api.id] = (short)(REQUESTS[api.id].length - 1);
        }
        for (ApiKeys api : ApiKeys.values()) {
            if (REQUESTS[api.id].length == RESPONSES[api.id].length) continue;
            throw new IllegalStateException(REQUESTS[api.id].length + " request versions for api " + api.name + " but " + RESPONSES[api.id].length + " response versions.");
        }
    }
}

