/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka09.shaded.org.apache.kafka.clients.producer.internals;

import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.kafka09.shaded.org.apache.kafka.clients.producer.Partitioner;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.Cluster;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.PartitionInfo;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.utils.Utils;

public class DefaultPartitioner
implements Partitioner {
    private final AtomicInteger counter = new AtomicInteger(new Random().nextInt());

    private static int toPositive(int number) {
        return number & Integer.MAX_VALUE;
    }

    @Override
    public void configure(Map<String, ?> configs) {
    }

    @Override
    public int partition(String topic, Object key, byte[] keyBytes, Object value, byte[] valueBytes, Cluster cluster) {
        List<PartitionInfo> partitions = cluster.partitionsForTopic(topic);
        int numPartitions = partitions.size();
        if (keyBytes == null) {
            int nextValue = this.counter.getAndIncrement();
            List<PartitionInfo> availablePartitions = cluster.availablePartitionsForTopic(topic);
            if (availablePartitions.size() > 0) {
                int part = DefaultPartitioner.toPositive(nextValue) % availablePartitions.size();
                return availablePartitions.get(part).partition();
            }
            return DefaultPartitioner.toPositive(nextValue) % numPartitions;
        }
        return DefaultPartitioner.toPositive(Utils.murmur2(keyBytes)) % numPartitions;
    }

    @Override
    public void close() {
    }
}

