/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka09.shaded.org.apache.kafka.clients.producer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.flink.kafka09.shaded.org.apache.kafka.clients.producer.Callback;
import org.apache.flink.kafka09.shaded.org.apache.kafka.clients.producer.Partitioner;
import org.apache.flink.kafka09.shaded.org.apache.kafka.clients.producer.Producer;
import org.apache.flink.kafka09.shaded.org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.flink.kafka09.shaded.org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.flink.kafka09.shaded.org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.flink.kafka09.shaded.org.apache.kafka.clients.producer.internals.FutureRecordMetadata;
import org.apache.flink.kafka09.shaded.org.apache.kafka.clients.producer.internals.ProduceRequestResult;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.Cluster;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.Metric;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.MetricName;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.PartitionInfo;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.serialization.Serializer;

public class MockProducer<K, V>
implements Producer<K, V> {
    private final Cluster cluster;
    private final Partitioner partitioner;
    private final List<ProducerRecord<K, V>> sent;
    private final Deque<Completion> completions;
    private boolean autoComplete;
    private Map<TopicPartition, Long> offsets;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;

    public MockProducer(Cluster cluster, boolean autoComplete, Partitioner partitioner, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.cluster = cluster;
        this.autoComplete = autoComplete;
        this.partitioner = partitioner;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.offsets = new HashMap<TopicPartition, Long>();
        this.sent = new ArrayList<ProducerRecord<K, V>>();
        this.completions = new ArrayDeque<Completion>();
    }

    public MockProducer(boolean autoComplete, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(Cluster.empty(), autoComplete, new DefaultPartitioner(), keySerializer, valueSerializer);
    }

    public MockProducer(boolean autoComplete, Partitioner partitioner, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(Cluster.empty(), autoComplete, partitioner, keySerializer, valueSerializer);
    }

    @Override
    public synchronized Future<RecordMetadata> send(ProducerRecord<K, V> record) {
        return this.send(record, null);
    }

    @Override
    public synchronized Future<RecordMetadata> send(ProducerRecord<K, V> record, Callback callback) {
        int partition = 0;
        if (this.cluster.partitionsForTopic(record.topic()) != null) {
            partition = this.partition(record, this.cluster);
        }
        ProduceRequestResult result = new ProduceRequestResult();
        FutureRecordMetadata future = new FutureRecordMetadata(result, 0L);
        TopicPartition topicPartition = new TopicPartition(record.topic(), partition);
        long offset = this.nextOffset(topicPartition);
        Completion completion = new Completion(topicPartition, offset, new RecordMetadata(topicPartition, 0L, offset), result, callback);
        this.sent.add(record);
        if (this.autoComplete) {
            completion.complete(null);
        } else {
            this.completions.addLast(completion);
        }
        return future;
    }

    private long nextOffset(TopicPartition tp) {
        Long offset = this.offsets.get(tp);
        if (offset == null) {
            this.offsets.put(tp, 1L);
            return 0L;
        }
        Long next = offset + 1L;
        this.offsets.put(tp, next);
        return offset;
    }

    @Override
    public synchronized void flush() {
        while (!this.completions.isEmpty()) {
            this.completeNext();
        }
    }

    @Override
    public List<PartitionInfo> partitionsFor(String topic) {
        return this.cluster.partitionsForTopic(topic);
    }

    @Override
    public Map<MetricName, Metric> metrics() {
        return Collections.emptyMap();
    }

    @Override
    public void close() {
    }

    @Override
    public void close(long timeout, TimeUnit timeUnit) {
    }

    public synchronized List<ProducerRecord<K, V>> history() {
        return new ArrayList<ProducerRecord<K, V>>(this.sent);
    }

    public synchronized void clear() {
        this.sent.clear();
        this.completions.clear();
    }

    public synchronized boolean completeNext() {
        return this.errorNext(null);
    }

    public synchronized boolean errorNext(RuntimeException e) {
        Completion completion = this.completions.pollFirst();
        if (completion != null) {
            completion.complete(e);
            return true;
        }
        return false;
    }

    private int partition(ProducerRecord<K, V> record, Cluster cluster) {
        Integer partition = record.partition();
        String topic = record.topic();
        if (partition != null) {
            List<PartitionInfo> partitions = cluster.partitionsForTopic(topic);
            int numPartitions = partitions.size();
            if (partition < 0 || partition >= numPartitions) {
                throw new IllegalArgumentException("Invalid partition given with record: " + partition + " is not in the range [0..." + numPartitions + "].");
            }
            return partition;
        }
        byte[] keyBytes = this.keySerializer.serialize(topic, record.key());
        byte[] valueBytes = this.valueSerializer.serialize(topic, record.value());
        return this.partitioner.partition(topic, record.key(), keyBytes, record.value(), valueBytes, cluster);
    }

    private static class Completion {
        private final long offset;
        private final RecordMetadata metadata;
        private final ProduceRequestResult result;
        private final Callback callback;
        private final TopicPartition topicPartition;

        public Completion(TopicPartition topicPartition, long offset, RecordMetadata metadata, ProduceRequestResult result, Callback callback) {
            this.metadata = metadata;
            this.offset = offset;
            this.result = result;
            this.callback = callback;
            this.topicPartition = topicPartition;
        }

        public void complete(RuntimeException e) {
            this.result.done(this.topicPartition, e == null ? this.offset : -1L, e);
            if (this.callback != null) {
                if (e == null) {
                    this.callback.onCompletion(this.metadata, null);
                } else {
                    this.callback.onCompletion(null, e);
                }
            }
        }
    }
}

