/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka09.shaded.org.apache.kafka.clients.consumer.internals;

public final class Heartbeat {
    private final long timeout;
    private final long interval;
    private long lastHeartbeatSend;
    private long lastHeartbeatReceive;
    private long lastSessionReset;

    public Heartbeat(long timeout, long interval, long now) {
        if (interval >= timeout) {
            throw new IllegalArgumentException("Heartbeat must be set lower than the session timeout");
        }
        this.timeout = timeout;
        this.interval = interval;
        this.lastSessionReset = now;
    }

    public void sentHeartbeat(long now) {
        this.lastHeartbeatSend = now;
    }

    public void receiveHeartbeat(long now) {
        this.lastHeartbeatReceive = now;
    }

    public boolean shouldHeartbeat(long now) {
        return this.timeToNextHeartbeat(now) == 0L;
    }

    public long lastHeartbeatSend() {
        return this.lastHeartbeatSend;
    }

    public long timeToNextHeartbeat(long now) {
        long timeSinceLastHeartbeat = now - Math.max(this.lastHeartbeatSend, this.lastSessionReset);
        if (timeSinceLastHeartbeat > this.interval) {
            return 0L;
        }
        return this.interval - timeSinceLastHeartbeat;
    }

    public boolean sessionTimeoutExpired(long now) {
        return now - Math.max(this.lastSessionReset, this.lastHeartbeatReceive) > this.timeout;
    }

    public long interval() {
        return this.interval;
    }

    public void resetSessionTimeout(long now) {
        this.lastSessionReset = now;
    }
}

