/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka09.shaded.org.apache.kafka.clients;

import org.apache.flink.kafka09.shaded.org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.flink.kafka09.shaded.org.apache.kafka.common.requests.RequestSend;

public final class ClientRequest {
    private final long createdTimeMs;
    private final boolean expectResponse;
    private final RequestSend request;
    private final RequestCompletionHandler callback;
    private final boolean isInitiatedByNetworkClient;
    private long sendTimeMs;

    public ClientRequest(long createdTimeMs, boolean expectResponse, RequestSend request, RequestCompletionHandler callback) {
        this(createdTimeMs, expectResponse, request, callback, false);
    }

    public ClientRequest(long createdTimeMs, boolean expectResponse, RequestSend request, RequestCompletionHandler callback, boolean isInitiatedByNetworkClient) {
        this.createdTimeMs = createdTimeMs;
        this.callback = callback;
        this.request = request;
        this.expectResponse = expectResponse;
        this.isInitiatedByNetworkClient = isInitiatedByNetworkClient;
    }

    public String toString() {
        return "ClientRequest(expectResponse=" + this.expectResponse + ", callback=" + this.callback + ", request=" + this.request + (this.isInitiatedByNetworkClient ? ", isInitiatedByNetworkClient" : "") + ", createdTimeMs=" + this.createdTimeMs + ", sendTimeMs=" + this.sendTimeMs + ")";
    }

    public boolean expectResponse() {
        return this.expectResponse;
    }

    public RequestSend request() {
        return this.request;
    }

    public boolean hasCallback() {
        return this.callback != null;
    }

    public RequestCompletionHandler callback() {
        return this.callback;
    }

    public long createdTimeMs() {
        return this.createdTimeMs;
    }

    public boolean isInitiatedByNetworkClient() {
        return this.isInitiatedByNetworkClient;
    }

    public long sendTimeMs() {
        return this.sendTimeMs;
    }

    public void setSendTimeMs(long sendTimeMs) {
        this.sendTimeMs = sendTimeMs;
    }
}

