/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumer08;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumerBase;
import org.apache.flink.streaming.connectors.kafka.KafkaAvroTableSource;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class Kafka08AvroTableSource
extends KafkaAvroTableSource {
    public Kafka08AvroTableSource(String topic, Properties properties, TableSchema schema, Class<? extends SpecificRecordBase> record) {
        super(topic, properties, schema, record);
    }

    public void setFieldMapping(Map<String, String> fieldMapping) {
        super.setFieldMapping(fieldMapping);
    }

    public void setProctimeAttribute(String proctimeAttribute) {
        super.setProctimeAttribute(proctimeAttribute);
    }

    public void setRowtimeAttributeDescriptor(RowtimeAttributeDescriptor rowtimeAttributeDescriptor) {
        Preconditions.checkNotNull((Object)rowtimeAttributeDescriptor, (String)"Rowtime attribute descriptor must not be null.");
        super.setRowtimeAttributeDescriptors(Collections.singletonList(rowtimeAttributeDescriptor));
    }

    protected FlinkKafkaConsumerBase<Row> createKafkaConsumer(String topic, Properties properties, DeserializationSchema<Row> deserializationSchema) {
        return new FlinkKafkaConsumer08<Row>(topic, deserializationSchema, properties);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends KafkaAvroTableSource.Builder<Kafka08AvroTableSource, Builder> {
        protected boolean supportsKafkaTimestamps() {
            return false;
        }

        protected Builder builder() {
            return this;
        }

        public Kafka08AvroTableSource build() {
            Kafka08AvroTableSource tableSource = new Kafka08AvroTableSource(this.getTopic(), this.getKafkaProps(), this.getTableSchema(), this.getAvroRecordClass());
            super.configureTableSource((KafkaAvroTableSource)tableSource);
            return tableSource;
        }
    }
}

