/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.internals;

import java.util.List;
import java.util.Properties;
import org.apache.flink.streaming.connectors.kafka.internals.Kafka08PartitionDiscoverer;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartitionLeader;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicsDescriptor;

class PartitionInfoFetcher
extends Thread {
    private final List<String> topics;
    private final Kafka08PartitionDiscoverer partitionDiscoverer;
    private volatile List<KafkaTopicPartitionLeader> result;
    private volatile Throwable error;

    PartitionInfoFetcher(List<String> topics, Properties properties) {
        this.partitionDiscoverer = new Kafka08PartitionDiscoverer(new KafkaTopicsDescriptor(topics, null), 0, 1, properties);
        this.topics = topics;
    }

    @Override
    public void run() {
        try {
            this.partitionDiscoverer.open();
            this.result = this.partitionDiscoverer.getPartitionLeadersForTopics(this.topics);
        }
        catch (Throwable t) {
            this.error = t;
        }
        finally {
            try {
                this.partitionDiscoverer.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Error while closing partition discoverer.", e);
            }
        }
    }

    public List<KafkaTopicPartitionLeader> getPartitions() throws Exception {
        try {
            this.join();
        }
        catch (InterruptedException e) {
            throw new Exception("Partition fetching was cancelled before completion");
        }
        if (this.error != null) {
            throw new Exception("Failed to fetch partitions for topics " + this.topics.toString(), this.error);
        }
        if (this.result != null) {
            return this.result;
        }
        throw new Exception("Partition fetching failed");
    }
}

