/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumer08;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumerBase;
import org.apache.flink.streaming.connectors.kafka.KafkaJsonTableSource;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class Kafka08JsonTableSource
extends KafkaJsonTableSource {
    public Kafka08JsonTableSource(String topic, Properties properties, TableSchema tableSchema, TableSchema jsonSchema) {
        super(topic, properties, tableSchema, jsonSchema);
    }

    public void setFailOnMissingField(boolean failOnMissingField) {
        super.setFailOnMissingField(failOnMissingField);
    }

    public void setFieldMapping(Map<String, String> fieldMapping) {
        super.setFieldMapping(fieldMapping);
    }

    public void setProctimeAttribute(String proctimeAttribute) {
        super.setProctimeAttribute(proctimeAttribute);
    }

    public void setRowtimeAttributeDescriptor(RowtimeAttributeDescriptor rowtimeAttributeDescriptor) {
        Preconditions.checkNotNull((Object)rowtimeAttributeDescriptor, (String)"Rowtime attribute descriptor must not be null.");
        super.setRowtimeAttributeDescriptors(Collections.singletonList(rowtimeAttributeDescriptor));
    }

    protected FlinkKafkaConsumerBase<Row> createKafkaConsumer(String topic, Properties properties, DeserializationSchema<Row> deserializationSchema) {
        return new FlinkKafkaConsumer08<Row>(topic, deserializationSchema, properties);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends KafkaJsonTableSource.Builder<Kafka08JsonTableSource, Builder> {
        protected boolean supportsKafkaTimestamps() {
            return false;
        }

        protected Builder builder() {
            return this;
        }

        public Kafka08JsonTableSource build() {
            Kafka08JsonTableSource tableSource = new Kafka08JsonTableSource(this.getTopic(), this.getKafkaProps(), this.getTableSchema(), this.getJsonSchema());
            super.configureTableSource((KafkaJsonTableSource)tableSource);
            return tableSource;
        }
    }
}

