/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.internals;

import java.util.List;
import java.util.Properties;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumer08;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartitionLeader;

class PartitionInfoFetcher
extends Thread {
    private final List<String> topics;
    private final Properties properties;
    private volatile List<KafkaTopicPartitionLeader> result;
    private volatile Throwable error;

    PartitionInfoFetcher(List<String> topics, Properties properties) {
        this.topics = topics;
        this.properties = properties;
    }

    @Override
    public void run() {
        try {
            this.result = FlinkKafkaConsumer08.getPartitionsForTopic(this.topics, this.properties);
        }
        catch (Throwable t) {
            this.error = t;
        }
    }

    public List<KafkaTopicPartitionLeader> getPartitions() throws Exception {
        try {
            this.join();
        }
        catch (InterruptedException e) {
            throw new Exception("Partition fetching was cancelled before completion");
        }
        if (this.error != null) {
            throw new Exception("Failed to fetch partitions for topics " + this.topics.toString(), this.error);
        }
        if (this.result != null) {
            return this.result;
        }
        throw new Exception("Partition fetching failed");
    }
}

