/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class SaslHandshakeResponse
extends AbstractResponse {
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private static final String ENABLED_MECHANISMS_KEY_NAME = "enabled_mechanisms";
    private final Errors error;
    private final List<String> enabledMechanisms;

    public SaslHandshakeResponse(Errors error, Collection<String> enabledMechanisms) {
        this.error = error;
        this.enabledMechanisms = new ArrayList<String>(enabledMechanisms);
    }

    public SaslHandshakeResponse(Struct struct) {
        this.error = Errors.forCode(struct.getShort(ERROR_CODE_KEY_NAME));
        Object[] mechanisms = struct.getArray(ENABLED_MECHANISMS_KEY_NAME);
        ArrayList<String> enabledMechanisms = new ArrayList<String>();
        for (Object mechanism : mechanisms) {
            enabledMechanisms.add((String)mechanism);
        }
        this.enabledMechanisms = enabledMechanisms;
    }

    public Errors error() {
        return this.error;
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.SASL_HANDSHAKE.responseSchema(version));
        struct.set(ERROR_CODE_KEY_NAME, (Object)this.error.code());
        struct.set(ENABLED_MECHANISMS_KEY_NAME, (Object)this.enabledMechanisms.toArray());
        return struct;
    }

    public List<String> enabledMechanisms() {
        return this.enabledMechanisms;
    }

    public static SaslHandshakeResponse parse(ByteBuffer buffer, short version) {
        return new SaslHandshakeResponse(ApiKeys.SASL_HANDSHAKE.parseResponse(version, buffer));
    }
}

