/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumerBase;
import org.apache.flink.streaming.connectors.kafka.config.StartupMode;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.sources.DefinedFieldMapping;
import org.apache.flink.table.sources.DefinedProctimeAttribute;
import org.apache.flink.table.sources.DefinedRowtimeAttributes;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.tsextractors.StreamRecordTimestamp;
import org.apache.flink.table.sources.tsextractors.TimestampExtractor;
import org.apache.flink.table.sources.wmstrategies.WatermarkStrategy;
import org.apache.flink.table.util.TableConnectorUtil;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import scala.Option;

@Internal
public abstract class KafkaTableSource
implements StreamTableSource<Row>,
DefinedProctimeAttribute,
DefinedRowtimeAttributes,
DefinedFieldMapping {
    private final TableSchema schema;
    private Optional<String> proctimeAttribute;
    private List<RowtimeAttributeDescriptor> rowtimeAttributeDescriptors;
    private Optional<Map<String, String>> fieldMapping;
    private final String topic;
    private final Properties properties;
    private final DeserializationSchema<Row> deserializationSchema;
    private StartupMode startupMode;
    private Map<KafkaTopicPartition, Long> specificStartupOffsets;

    protected KafkaTableSource(TableSchema schema, Optional<String> proctimeAttribute, List<RowtimeAttributeDescriptor> rowtimeAttributeDescriptors, Optional<Map<String, String>> fieldMapping, String topic, Properties properties, DeserializationSchema<Row> deserializationSchema, StartupMode startupMode, Map<KafkaTopicPartition, Long> specificStartupOffsets) {
        this.schema = (TableSchema)Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        this.proctimeAttribute = this.validateProctimeAttribute(proctimeAttribute);
        this.rowtimeAttributeDescriptors = this.validateRowtimeAttributeDescriptors(rowtimeAttributeDescriptors);
        this.fieldMapping = fieldMapping;
        this.topic = (String)Preconditions.checkNotNull((Object)topic, (String)"Topic must not be null.");
        this.properties = (Properties)Preconditions.checkNotNull((Object)properties, (String)"Properties must not be null.");
        this.deserializationSchema = (DeserializationSchema)Preconditions.checkNotNull(deserializationSchema, (String)"Deserialization schema must not be null.");
        this.startupMode = (StartupMode)((Object)Preconditions.checkNotNull((Object)((Object)startupMode), (String)"Startup mode must not be null."));
        this.specificStartupOffsets = (Map)Preconditions.checkNotNull(specificStartupOffsets, (String)"Specific offsets must not be null.");
    }

    protected KafkaTableSource(TableSchema schema, String topic, Properties properties, DeserializationSchema<Row> deserializationSchema) {
        this(schema, Optional.empty(), Collections.emptyList(), Optional.empty(), topic, properties, deserializationSchema, StartupMode.GROUP_OFFSETS, Collections.emptyMap());
    }

    public DataStream<Row> getDataStream(StreamExecutionEnvironment env) {
        DeserializationSchema<Row> deserializationSchema = this.getDeserializationSchema();
        FlinkKafkaConsumerBase<Row> kafkaConsumer = this.getKafkaConsumer(this.topic, this.properties, deserializationSchema);
        return env.addSource(kafkaConsumer).name(this.explainSource());
    }

    public TypeInformation<Row> getReturnType() {
        return this.deserializationSchema.getProducedType();
    }

    public TableSchema getTableSchema() {
        return this.schema;
    }

    public String getProctimeAttribute() {
        return this.proctimeAttribute.orElse(null);
    }

    public List<RowtimeAttributeDescriptor> getRowtimeAttributeDescriptors() {
        return this.rowtimeAttributeDescriptors;
    }

    public Map<String, String> getFieldMapping() {
        return this.fieldMapping.orElse(null);
    }

    public String explainSource() {
        return TableConnectorUtil.generateRuntimeName(this.getClass(), (String[])this.schema.getColumnNames());
    }

    public Properties getProperties() {
        return this.properties;
    }

    public DeserializationSchema<Row> getDeserializationSchema() {
        return this.deserializationSchema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof KafkaTableSource)) {
            return false;
        }
        KafkaTableSource that = (KafkaTableSource)o;
        return Objects.equals(this.schema, that.schema) && Objects.equals(this.proctimeAttribute, that.proctimeAttribute) && Objects.equals(this.rowtimeAttributeDescriptors, that.rowtimeAttributeDescriptors) && Objects.equals(this.fieldMapping, that.fieldMapping) && Objects.equals(this.topic, that.topic) && Objects.equals(this.properties, that.properties) && Objects.equals(this.deserializationSchema, that.deserializationSchema) && this.startupMode == that.startupMode && Objects.equals(this.specificStartupOffsets, that.specificStartupOffsets);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schema, this.proctimeAttribute, this.rowtimeAttributeDescriptors, this.fieldMapping, this.topic, this.properties, this.deserializationSchema, this.startupMode, this.specificStartupOffsets});
    }

    protected FlinkKafkaConsumerBase<Row> getKafkaConsumer(String topic, Properties properties, DeserializationSchema<Row> deserializationSchema) {
        FlinkKafkaConsumerBase<Row> kafkaConsumer = this.createKafkaConsumer(topic, properties, deserializationSchema);
        switch (this.startupMode) {
            case EARLIEST: {
                kafkaConsumer.setStartFromEarliest();
                break;
            }
            case LATEST: {
                kafkaConsumer.setStartFromLatest();
                break;
            }
            case GROUP_OFFSETS: {
                kafkaConsumer.setStartFromGroupOffsets();
                break;
            }
            case SPECIFIC_OFFSETS: {
                kafkaConsumer.setStartFromSpecificOffsets(this.specificStartupOffsets);
            }
        }
        return kafkaConsumer;
    }

    private Optional<String> validateProctimeAttribute(Optional<String> proctimeAttribute) {
        return proctimeAttribute.map(attribute -> {
            Option tpe = this.schema.getType(attribute);
            if (tpe.isEmpty()) {
                throw new ValidationException("Processing time attribute '" + attribute + "' is not present in TableSchema.");
            }
            if (tpe.get() != Types.SQL_TIMESTAMP()) {
                throw new ValidationException("Processing time attribute '" + attribute + "' is not of type SQL_TIMESTAMP.");
            }
            return attribute;
        });
    }

    private List<RowtimeAttributeDescriptor> validateRowtimeAttributeDescriptors(List<RowtimeAttributeDescriptor> rowtimeAttributeDescriptors) {
        Preconditions.checkNotNull(rowtimeAttributeDescriptors, (String)"List of rowtime attributes must not be null.");
        for (RowtimeAttributeDescriptor desc : rowtimeAttributeDescriptors) {
            String rowtimeAttribute = desc.getAttributeName();
            Option tpe = this.schema.getType(rowtimeAttribute);
            if (tpe.isEmpty()) {
                throw new ValidationException("Rowtime attribute '" + rowtimeAttribute + "' is not present in TableSchema.");
            }
            if (tpe.get() == Types.SQL_TIMESTAMP()) continue;
            throw new ValidationException("Rowtime attribute '" + rowtimeAttribute + "' is not of type SQL_TIMESTAMP.");
        }
        return rowtimeAttributeDescriptors;
    }

    @Deprecated
    protected void setProctimeAttribute(String proctimeAttribute) {
        this.proctimeAttribute = this.validateProctimeAttribute(Optional.ofNullable(proctimeAttribute));
    }

    @Deprecated
    protected void setRowtimeAttributeDescriptors(List<RowtimeAttributeDescriptor> rowtimeAttributeDescriptors) {
        this.rowtimeAttributeDescriptors = this.validateRowtimeAttributeDescriptors(rowtimeAttributeDescriptors);
    }

    @Deprecated
    protected void setStartupMode(StartupMode startupMode) {
        this.startupMode = (StartupMode)((Object)Preconditions.checkNotNull((Object)((Object)startupMode)));
    }

    @Deprecated
    protected void setSpecificStartupOffsets(Map<KafkaTopicPartition, Long> specificStartupOffsets) {
        this.specificStartupOffsets = (Map)Preconditions.checkNotNull(specificStartupOffsets);
    }

    @Deprecated
    protected void setFieldMapping(Map<String, String> fieldMapping) {
        this.fieldMapping = Optional.ofNullable(fieldMapping);
    }

    protected abstract FlinkKafkaConsumerBase<Row> createKafkaConsumer(String var1, Properties var2, DeserializationSchema<Row> var3);

    @Deprecated
    protected static abstract class Builder<T extends KafkaTableSource, B extends Builder> {
        private String topic;
        private Properties kafkaProps;
        private TableSchema schema;
        private String proctimeAttribute;
        private RowtimeAttributeDescriptor rowtimeAttributeDescriptor;
        private StartupMode startupMode = StartupMode.GROUP_OFFSETS;
        private Map<KafkaTopicPartition, Long> specificStartupOffsets = null;

        protected Builder() {
        }

        @Deprecated
        public B forTopic(String topic) {
            Preconditions.checkNotNull((Object)topic, (String)"Topic must not be null.");
            Preconditions.checkArgument((this.topic == null ? 1 : 0) != 0, (Object)"Topic has already been set.");
            this.topic = topic;
            return this.builder();
        }

        @Deprecated
        public B withKafkaProperties(Properties props) {
            Preconditions.checkNotNull((Object)props, (String)"Properties must not be null.");
            Preconditions.checkArgument((this.kafkaProps == null ? 1 : 0) != 0, (Object)"Properties have already been set.");
            this.kafkaProps = props;
            return this.builder();
        }

        @Deprecated
        public B withSchema(TableSchema schema) {
            Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
            Preconditions.checkArgument((this.schema == null ? 1 : 0) != 0, (Object)"Schema has already been set.");
            this.schema = schema;
            return this.builder();
        }

        @Deprecated
        public B withProctimeAttribute(String proctimeAttribute) {
            Preconditions.checkNotNull((Object)proctimeAttribute, (String)"Proctime attribute must not be null.");
            Preconditions.checkArgument((!proctimeAttribute.isEmpty() ? 1 : 0) != 0, (Object)"Proctime attribute must not be empty.");
            Preconditions.checkArgument((this.proctimeAttribute == null ? 1 : 0) != 0, (Object)"Proctime attribute has already been set.");
            this.proctimeAttribute = proctimeAttribute;
            return this.builder();
        }

        @Deprecated
        public B withRowtimeAttribute(String rowtimeAttribute, TimestampExtractor timestampExtractor, WatermarkStrategy watermarkStrategy) {
            Preconditions.checkNotNull((Object)rowtimeAttribute, (String)"Rowtime attribute must not be null.");
            Preconditions.checkArgument((!rowtimeAttribute.isEmpty() ? 1 : 0) != 0, (Object)"Rowtime attribute must not be empty.");
            Preconditions.checkNotNull((Object)timestampExtractor, (String)"Timestamp extractor must not be null.");
            Preconditions.checkNotNull((Object)watermarkStrategy, (String)"Watermark assigner must not be null.");
            Preconditions.checkArgument((this.rowtimeAttributeDescriptor == null ? 1 : 0) != 0, (Object)"Currently, only one rowtime attribute is supported.");
            this.rowtimeAttributeDescriptor = new RowtimeAttributeDescriptor(rowtimeAttribute, timestampExtractor, watermarkStrategy);
            return this.builder();
        }

        @Deprecated
        public B withKafkaTimestampAsRowtimeAttribute(String rowtimeAttribute, WatermarkStrategy watermarkStrategy) {
            Preconditions.checkNotNull((Object)rowtimeAttribute, (String)"Rowtime attribute must not be null.");
            Preconditions.checkArgument((!rowtimeAttribute.isEmpty() ? 1 : 0) != 0, (Object)"Rowtime attribute must not be empty.");
            Preconditions.checkNotNull((Object)watermarkStrategy, (String)"Watermark assigner must not be null.");
            Preconditions.checkArgument((this.rowtimeAttributeDescriptor == null ? 1 : 0) != 0, (Object)"Currently, only one rowtime attribute is supported.");
            Preconditions.checkArgument((boolean)this.supportsKafkaTimestamps(), (Object)"Kafka timestamps are only supported since Kafka 0.10.");
            this.rowtimeAttributeDescriptor = new RowtimeAttributeDescriptor(rowtimeAttribute, (TimestampExtractor)new StreamRecordTimestamp(), watermarkStrategy);
            return this.builder();
        }

        @Deprecated
        public B fromEarliest() {
            this.startupMode = StartupMode.EARLIEST;
            this.specificStartupOffsets = null;
            return this.builder();
        }

        @Deprecated
        public B fromLatest() {
            this.startupMode = StartupMode.LATEST;
            this.specificStartupOffsets = null;
            return this.builder();
        }

        @Deprecated
        public B fromGroupOffsets() {
            this.startupMode = StartupMode.GROUP_OFFSETS;
            this.specificStartupOffsets = null;
            return this.builder();
        }

        @Deprecated
        public B fromSpecificOffsets(Map<KafkaTopicPartition, Long> specificStartupOffsets) {
            this.startupMode = StartupMode.SPECIFIC_OFFSETS;
            this.specificStartupOffsets = (Map)Preconditions.checkNotNull(specificStartupOffsets);
            return this.builder();
        }

        @Deprecated
        protected String getTopic() {
            return this.topic;
        }

        @Deprecated
        protected Properties getKafkaProps() {
            return this.kafkaProps;
        }

        @Deprecated
        protected TableSchema getTableSchema() {
            return this.schema;
        }

        @Deprecated
        protected abstract boolean supportsKafkaTimestamps();

        @Deprecated
        protected void configureTableSource(T tableSource) {
            ((KafkaTableSource)tableSource).setProctimeAttribute(this.proctimeAttribute);
            if (this.rowtimeAttributeDescriptor == null) {
                ((KafkaTableSource)tableSource).setRowtimeAttributeDescriptors(Collections.emptyList());
            } else {
                ((KafkaTableSource)tableSource).setRowtimeAttributeDescriptors(Collections.singletonList(this.rowtimeAttributeDescriptor));
            }
            ((KafkaTableSource)tableSource).setStartupMode(this.startupMode);
            switch (this.startupMode) {
                case EARLIEST: 
                case LATEST: 
                case GROUP_OFFSETS: {
                    break;
                }
                case SPECIFIC_OFFSETS: {
                    ((KafkaTableSource)tableSource).setSpecificStartupOffsets(this.specificStartupOffsets);
                }
            }
        }

        @Deprecated
        protected abstract B builder();

        @Deprecated
        protected abstract KafkaTableSource build();
    }
}

