/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka011.shaded.org.apache.kafka.common.serialization;

import java.util.Map;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.errors.SerializationException;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.serialization.Deserializer;

public class LongDeserializer
implements Deserializer<Long> {
    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    @Override
    public Long deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length != 8) {
            throw new SerializationException("Size of data received by LongDeserializer is not 8");
        }
        long value = 0L;
        for (byte b : data) {
            value <<= 8;
            value |= (long)(b & 0xFF);
        }
        return value;
    }

    @Override
    public void close() {
    }
}

