/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests;

import org.apache.flink.kafka011.shaded.org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.acl.AclOperation;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.acl.AclPermissionType;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.resource.Resource;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.resource.ResourceFilter;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.resource.ResourceType;

class RequestUtils {
    RequestUtils() {
    }

    static Resource resourceFromStructFields(Struct struct) {
        byte resourceType = struct.getByte("resource_type");
        String name = struct.getString("resource_name");
        return new Resource(ResourceType.fromCode(resourceType), name);
    }

    static void resourceSetStructFields(Resource resource, Struct struct) {
        struct.set("resource_type", (Object)resource.resourceType().code());
        struct.set("resource_name", (Object)resource.name());
    }

    static ResourceFilter resourceFilterFromStructFields(Struct struct) {
        byte resourceType = struct.getByte("resource_type");
        String name = struct.getString("resource_name");
        return new ResourceFilter(ResourceType.fromCode(resourceType), name);
    }

    static void resourceFilterSetStructFields(ResourceFilter resourceFilter, Struct struct) {
        struct.set("resource_type", (Object)resourceFilter.resourceType().code());
        struct.set("resource_name", (Object)resourceFilter.name());
    }

    static AccessControlEntry aceFromStructFields(Struct struct) {
        String principal = struct.getString("principal");
        String host = struct.getString("host");
        byte operation = struct.getByte("operation");
        byte permissionType = struct.getByte("permission_type");
        return new AccessControlEntry(principal, host, AclOperation.fromCode(operation), AclPermissionType.fromCode(permissionType));
    }

    static void aceSetStructFields(AccessControlEntry data, Struct struct) {
        struct.set("principal", (Object)data.principal());
        struct.set("host", (Object)data.host());
        struct.set("operation", (Object)data.operation().code());
        struct.set("permission_type", (Object)data.permissionType().code());
    }

    static AccessControlEntryFilter aceFilterFromStructFields(Struct struct) {
        String principal = struct.getString("principal");
        String host = struct.getString("host");
        byte operation = struct.getByte("operation");
        byte permissionType = struct.getByte("permission_type");
        return new AccessControlEntryFilter(principal, host, AclOperation.fromCode(operation), AclPermissionType.fromCode(permissionType));
    }

    static void aceFilterSetStructFields(AccessControlEntryFilter filter, Struct struct) {
        struct.set("principal", (Object)filter.principal());
        struct.set("host", (Object)filter.host());
        struct.set("operation", (Object)filter.operation().code());
        struct.set("permission_type", (Object)filter.permissionType().code());
    }
}

