/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.MetadataResponse;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.utils.Utils;

public class MetadataRequest
extends AbstractRequest {
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String ALLOW_AUTO_TOPIC_CREATION_KEY_NAME = "allow_auto_topic_creation";
    private final List<String> topics;
    private final boolean allowAutoTopicCreation;

    public MetadataRequest(List<String> topics, boolean allowAutoTopicCreation, short version) {
        super(version);
        this.topics = topics;
        this.allowAutoTopicCreation = allowAutoTopicCreation;
    }

    public MetadataRequest(Struct struct, short version) {
        super(version);
        Object[] topicArray = struct.getArray(TOPICS_KEY_NAME);
        if (topicArray != null) {
            this.topics = new ArrayList<String>();
            for (Object topicObj : topicArray) {
                this.topics.add((String)topicObj);
            }
        } else {
            this.topics = null;
        }
        this.allowAutoTopicCreation = struct.hasField(ALLOW_AUTO_TOPIC_CREATION_KEY_NAME) ? struct.getBoolean(ALLOW_AUTO_TOPIC_CREATION_KEY_NAME) : true;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ArrayList<MetadataResponse.TopicMetadata> topicMetadatas = new ArrayList<MetadataResponse.TopicMetadata>();
        Errors error = Errors.forException(e);
        List<MetadataResponse.PartitionMetadata> partitions = Collections.emptyList();
        if (this.topics != null) {
            for (String topic : this.topics) {
                topicMetadatas.add(new MetadataResponse.TopicMetadata(error, topic, false, partitions));
            }
        }
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: 
            case 2: {
                return new MetadataResponse(Collections.emptyList(), null, -1, topicMetadatas);
            }
            case 3: 
            case 4: {
                return new MetadataResponse(throttleTimeMs, Collections.emptyList(), null, -1, topicMetadatas);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.METADATA.latestVersion()));
    }

    public boolean isAllTopics() {
        return this.topics == null;
    }

    public List<String> topics() {
        return this.topics;
    }

    public boolean allowAutoTopicCreation() {
        return this.allowAutoTopicCreation;
    }

    public static MetadataRequest parse(ByteBuffer buffer, short version) {
        return new MetadataRequest(ApiKeys.METADATA.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.METADATA.requestSchema(this.version()));
        if (this.topics == null) {
            struct.set(TOPICS_KEY_NAME, null);
        } else {
            struct.set(TOPICS_KEY_NAME, (Object)this.topics.toArray());
        }
        if (struct.hasField(ALLOW_AUTO_TOPIC_CREATION_KEY_NAME)) {
            struct.set(ALLOW_AUTO_TOPIC_CREATION_KEY_NAME, (Object)this.allowAutoTopicCreation);
        }
        return struct;
    }

    public static class Builder
    extends AbstractRequest.Builder<MetadataRequest> {
        private static final List<String> ALL_TOPICS = null;
        private final List<String> topics;
        private final boolean allowAutoTopicCreation;

        public static Builder allTopics() {
            return new Builder(ALL_TOPICS, true);
        }

        public Builder(List<String> topics, boolean allowAutoTopicCreation) {
            super(ApiKeys.METADATA);
            this.topics = topics;
            this.allowAutoTopicCreation = allowAutoTopicCreation;
        }

        public List<String> topics() {
            return this.topics;
        }

        public boolean isAllTopics() {
            return this.topics == ALL_TOPICS;
        }

        @Override
        public MetadataRequest build(short version) {
            if (version < 1) {
                throw new UnsupportedVersionException("MetadataRequest versions older than 1 are not supported.");
            }
            if (!this.allowAutoTopicCreation && version < 4) {
                throw new UnsupportedVersionException("MetadataRequest versions older than 4 don't support the allowAutoTopicCreation field");
            }
            return new MetadataRequest(this.topics, this.allowAutoTopicCreation, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=MetadataRequest").append(", topics=");
            if (this.topics == null) {
                bld.append("<ALL>");
            } else {
                bld.append(Utils.join(this.topics, ","));
            }
            bld.append(")");
            return bld.toString();
        }
    }
}

