/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class JoinGroupResponse
extends AbstractResponse {
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private static final String GENERATION_ID_KEY_NAME = "generation_id";
    private static final String GROUP_PROTOCOL_KEY_NAME = "group_protocol";
    private static final String LEADER_ID_KEY_NAME = "leader_id";
    private static final String MEMBER_ID_KEY_NAME = "member_id";
    private static final String MEMBERS_KEY_NAME = "members";
    private static final String MEMBER_METADATA_KEY_NAME = "member_metadata";
    public static final String UNKNOWN_PROTOCOL = "";
    public static final int UNKNOWN_GENERATION_ID = -1;
    public static final String UNKNOWN_MEMBER_ID = "";
    private final int throttleTimeMs;
    private final Errors error;
    private final int generationId;
    private final String groupProtocol;
    private final String memberId;
    private final String leaderId;
    private final Map<String, ByteBuffer> members;

    public JoinGroupResponse(Errors error, int generationId, String groupProtocol, String memberId, String leaderId, Map<String, ByteBuffer> groupMembers) {
        this(0, error, generationId, groupProtocol, memberId, leaderId, groupMembers);
    }

    public JoinGroupResponse(int throttleTimeMs, Errors error, int generationId, String groupProtocol, String memberId, String leaderId, Map<String, ByteBuffer> groupMembers) {
        this.throttleTimeMs = throttleTimeMs;
        this.error = error;
        this.generationId = generationId;
        this.groupProtocol = groupProtocol;
        this.memberId = memberId;
        this.leaderId = leaderId;
        this.members = groupMembers;
    }

    public JoinGroupResponse(Struct struct) {
        this.throttleTimeMs = struct.hasField("throttle_time_ms") ? struct.getInt("throttle_time_ms") : 0;
        this.members = new HashMap<String, ByteBuffer>();
        for (Object memberDataObj : struct.getArray(MEMBERS_KEY_NAME)) {
            Struct memberData = (Struct)memberDataObj;
            String memberId = memberData.getString(MEMBER_ID_KEY_NAME);
            ByteBuffer memberMetadata = memberData.getBytes(MEMBER_METADATA_KEY_NAME);
            this.members.put(memberId, memberMetadata);
        }
        this.error = Errors.forCode(struct.getShort(ERROR_CODE_KEY_NAME));
        this.generationId = struct.getInt(GENERATION_ID_KEY_NAME);
        this.groupProtocol = struct.getString(GROUP_PROTOCOL_KEY_NAME);
        this.memberId = struct.getString(MEMBER_ID_KEY_NAME);
        this.leaderId = struct.getString(LEADER_ID_KEY_NAME);
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Errors error() {
        return this.error;
    }

    public int generationId() {
        return this.generationId;
    }

    public String groupProtocol() {
        return this.groupProtocol;
    }

    public String memberId() {
        return this.memberId;
    }

    public String leaderId() {
        return this.leaderId;
    }

    public boolean isLeader() {
        return this.memberId.equals(this.leaderId);
    }

    public Map<String, ByteBuffer> members() {
        return this.members;
    }

    public static JoinGroupResponse parse(ByteBuffer buffer, short version) {
        return new JoinGroupResponse(ApiKeys.JOIN_GROUP.parseResponse(version, buffer));
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.JOIN_GROUP.responseSchema(version));
        if (struct.hasField("throttle_time_ms")) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        struct.set(ERROR_CODE_KEY_NAME, (Object)this.error.code());
        struct.set(GENERATION_ID_KEY_NAME, (Object)this.generationId);
        struct.set(GROUP_PROTOCOL_KEY_NAME, (Object)this.groupProtocol);
        struct.set(MEMBER_ID_KEY_NAME, (Object)this.memberId);
        struct.set(LEADER_ID_KEY_NAME, (Object)this.leaderId);
        ArrayList<Struct> memberArray = new ArrayList<Struct>();
        for (Map.Entry<String, ByteBuffer> entries : this.members.entrySet()) {
            Struct memberData = struct.instance(MEMBERS_KEY_NAME);
            memberData.set(MEMBER_ID_KEY_NAME, (Object)entries.getKey());
            memberData.set(MEMBER_METADATA_KEY_NAME, (Object)entries.getValue());
            memberArray.add(memberData);
        }
        struct.set(MEMBERS_KEY_NAME, (Object)memberArray.toArray());
        return struct;
    }
}

