/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.Node;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.FindCoordinatorResponse;

public class FindCoordinatorRequest
extends AbstractRequest {
    private static final String GROUP_ID_KEY_NAME = "group_id";
    private static final String COORDINATOR_KEY_KEY_NAME = "coordinator_key";
    private static final String COORDINATOR_TYPE_KEY_NAME = "coordinator_type";
    private final String coordinatorKey;
    private final CoordinatorType coordinatorType;

    private FindCoordinatorRequest(CoordinatorType coordinatorType, String coordinatorKey, short version) {
        super(version);
        this.coordinatorType = coordinatorType;
        this.coordinatorKey = coordinatorKey;
    }

    public FindCoordinatorRequest(Struct struct, short version) {
        super(version);
        this.coordinatorType = struct.hasField(COORDINATOR_TYPE_KEY_NAME) ? CoordinatorType.forId(struct.getByte(COORDINATOR_TYPE_KEY_NAME)) : CoordinatorType.GROUP;
        this.coordinatorKey = struct.hasField(GROUP_ID_KEY_NAME) ? struct.getString(GROUP_ID_KEY_NAME) : struct.getString(COORDINATOR_KEY_KEY_NAME);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                return new FindCoordinatorResponse(Errors.forException(e), Node.noNode());
            }
            case 1: {
                return new FindCoordinatorResponse(throttleTimeMs, Errors.forException(e), Node.noNode());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.FIND_COORDINATOR.latestVersion()));
    }

    public String coordinatorKey() {
        return this.coordinatorKey;
    }

    public CoordinatorType coordinatorType() {
        return this.coordinatorType;
    }

    public static FindCoordinatorRequest parse(ByteBuffer buffer, short version) {
        return new FindCoordinatorRequest(ApiKeys.FIND_COORDINATOR.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.FIND_COORDINATOR.requestSchema(this.version()));
        if (struct.hasField(GROUP_ID_KEY_NAME)) {
            struct.set(GROUP_ID_KEY_NAME, (Object)this.coordinatorKey);
        } else {
            struct.set(COORDINATOR_KEY_KEY_NAME, (Object)this.coordinatorKey);
        }
        if (struct.hasField(COORDINATOR_TYPE_KEY_NAME)) {
            struct.set(COORDINATOR_TYPE_KEY_NAME, (Object)this.coordinatorType.id);
        }
        return struct;
    }

    public static enum CoordinatorType {
        GROUP(0),
        TRANSACTION(1);

        final byte id;

        private CoordinatorType(byte id) {
            this.id = id;
        }

        public static CoordinatorType forId(byte id) {
            switch (id) {
                case 0: {
                    return GROUP;
                }
                case 1: {
                    return TRANSACTION;
                }
            }
            throw new IllegalArgumentException("Unknown coordinator type received: " + id);
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<FindCoordinatorRequest> {
        private final String coordinatorKey;
        private final CoordinatorType coordinatorType;
        private final short minVersion;

        public Builder(CoordinatorType coordinatorType, String coordinatorKey) {
            super(ApiKeys.FIND_COORDINATOR);
            this.coordinatorType = coordinatorType;
            this.coordinatorKey = coordinatorKey;
            this.minVersion = coordinatorType == CoordinatorType.TRANSACTION ? (short)1 : 0;
        }

        @Override
        public FindCoordinatorRequest build(short version) {
            if (version < this.minVersion) {
                throw new UnsupportedVersionException("Cannot create a v" + version + " FindCoordinator request " + "because we require features supported only in " + this.minVersion + " or later.");
            }
            return new FindCoordinatorRequest(this.coordinatorType, this.coordinatorKey, version);
        }

        public String coordinatorKey() {
            return this.coordinatorKey;
        }

        public CoordinatorType coordinatorType() {
            return this.coordinatorType;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=FindCoordinatorRequest, coordinatorKey=");
            bld.append(this.coordinatorKey);
            bld.append(", coordinatorType=");
            bld.append((Object)this.coordinatorType);
            bld.append(")");
            return bld.toString();
        }
    }
}

