/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka011.shaded.org.apache.kafka.common.config;

import java.util.Objects;

public final class ConfigResource {
    private final Type type;
    private final String name;

    public ConfigResource(Type type, String name) {
        Objects.requireNonNull(type, "type should not be null");
        Objects.requireNonNull(name, "name should not be null");
        this.type = type;
        this.name = name;
    }

    public Type type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigResource that = (ConfigResource)o;
        return this.type == that.type && this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return "ConfigResource{type=" + (Object)((Object)this.type) + ", name='" + this.name + "'}";
    }

    public static enum Type {
        BROKER,
        TOPIC,
        UNKNOWN;

    }
}

