/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka011.shaded.org.apache.kafka.clients.producer.internals;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.MetricName;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.errors.TimeoutException;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.metrics.Metrics;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.metrics.Sensor;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.metrics.stats.Rate;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.utils.Time;

public class BufferPool {
    static final String WAIT_TIME_SENSOR_NAME = "bufferpool-wait-time";
    private final long totalMemory;
    private final int poolableSize;
    private final ReentrantLock lock;
    private final Deque<ByteBuffer> free;
    private final Deque<Condition> waiters;
    private long availableMemory;
    private final Metrics metrics;
    private final Time time;
    private final Sensor waitTime;

    public BufferPool(long memory, int poolableSize, Metrics metrics, Time time, String metricGrpName) {
        this.poolableSize = poolableSize;
        this.lock = new ReentrantLock();
        this.free = new ArrayDeque<ByteBuffer>();
        this.waiters = new ArrayDeque<Condition>();
        this.totalMemory = memory;
        this.availableMemory = memory;
        this.metrics = metrics;
        this.time = time;
        this.waitTime = this.metrics.sensor(WAIT_TIME_SENSOR_NAME);
        MetricName metricName = metrics.metricName("bufferpool-wait-ratio", metricGrpName, "The fraction of time an appender waits for space allocation.");
        this.waitTime.add(metricName, new Rate(TimeUnit.NANOSECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer allocate(int size, long maxTimeToBlockMs) throws InterruptedException {
        if ((long)size > this.totalMemory) {
            throw new IllegalArgumentException("Attempt to allocate " + size + " bytes, but there is a hard limit of " + this.totalMemory + " on memory allocations.");
        }
        this.lock.lock();
        try {
            ByteBuffer byteBuffer;
            Condition moreMemory;
            block30: {
                if (size == this.poolableSize && !this.free.isEmpty()) {
                    ByteBuffer byteBuffer2 = this.free.pollFirst();
                    return byteBuffer2;
                }
                int freeListSize = this.freeSize() * this.poolableSize;
                if (this.availableMemory + (long)freeListSize >= (long)size) {
                    this.freeUp(size);
                    ByteBuffer allocatedBuffer = this.allocateByteBuffer(size);
                    this.availableMemory -= (long)size;
                    ByteBuffer byteBuffer3 = allocatedBuffer;
                    return byteBuffer3;
                }
                int accumulated = 0;
                ByteBuffer buffer = null;
                boolean hasError = true;
                moreMemory = this.lock.newCondition();
                try {
                    long remainingTimeToBlockNs = TimeUnit.MILLISECONDS.toNanos(maxTimeToBlockMs);
                    this.waiters.addLast(moreMemory);
                    while (accumulated < size) {
                        long timeNs;
                        boolean waitingTimeElapsed;
                        long startWaitNs = this.time.nanoseconds();
                        try {
                            waitingTimeElapsed = !moreMemory.await(remainingTimeToBlockNs, TimeUnit.NANOSECONDS);
                        }
                        finally {
                            long endWaitNs = this.time.nanoseconds();
                            timeNs = Math.max(0L, endWaitNs - startWaitNs);
                            this.waitTime.record(timeNs, this.time.milliseconds());
                        }
                        if (waitingTimeElapsed) {
                            throw new TimeoutException("Failed to allocate memory within the configured max blocking time " + maxTimeToBlockMs + " ms.");
                        }
                        remainingTimeToBlockNs -= timeNs;
                        if (accumulated == 0 && size == this.poolableSize && !this.free.isEmpty()) {
                            buffer = this.free.pollFirst();
                            accumulated = size;
                            continue;
                        }
                        this.freeUp(size - accumulated);
                        int got = (int)Math.min((long)(size - accumulated), this.availableMemory);
                        this.availableMemory -= (long)got;
                        accumulated += got;
                    }
                    if (buffer == null) {
                        buffer = this.allocateByteBuffer(size);
                    }
                    hasError = false;
                    byteBuffer = buffer;
                    if (!hasError) break block30;
                }
                catch (Throwable throwable) {
                    if (hasError) {
                        this.availableMemory += (long)accumulated;
                    }
                    this.waiters.remove(moreMemory);
                    throw throwable;
                }
                this.availableMemory += (long)accumulated;
            }
            this.waiters.remove(moreMemory);
            return byteBuffer;
        }
        finally {
            try {
                if (!(this.availableMemory == 0L && this.free.isEmpty() || this.waiters.isEmpty())) {
                    this.waiters.peekFirst().signal();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected ByteBuffer allocateByteBuffer(int size) {
        return ByteBuffer.allocate(size);
    }

    private void freeUp(int size) {
        while (!this.free.isEmpty() && this.availableMemory < (long)size) {
            this.availableMemory += (long)this.free.pollLast().capacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deallocate(ByteBuffer buffer, int size) {
        this.lock.lock();
        try {
            if (size == this.poolableSize && size == buffer.capacity()) {
                buffer.clear();
                this.free.add(buffer);
            } else {
                this.availableMemory += (long)size;
            }
            Condition moreMem = this.waiters.peekFirst();
            if (moreMem != null) {
                moreMem.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void deallocate(ByteBuffer buffer) {
        this.deallocate(buffer, buffer.capacity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long availableMemory() {
        this.lock.lock();
        try {
            long l = this.availableMemory + (long)this.freeSize() * (long)this.poolableSize;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected int freeSize() {
        return this.free.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long unallocatedMemory() {
        this.lock.lock();
        try {
            long l = this.availableMemory;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queued() {
        this.lock.lock();
        try {
            int n = this.waiters.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int poolableSize() {
        return this.poolableSize;
    }

    public long totalMemory() {
        return this.totalMemory;
    }

    Deque<Condition> waiters() {
        return this.waiters;
    }
}

