/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka010.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.Node;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.requests.GroupCoordinatorResponse;

public class GroupCoordinatorRequest
extends AbstractRequest {
    private static final String GROUP_ID_KEY_NAME = "group_id";
    private final String groupId;

    private GroupCoordinatorRequest(String groupId, short version) {
        super(new Struct(ProtoUtils.requestSchema(ApiKeys.GROUP_COORDINATOR.id, version)), version);
        this.struct.set(GROUP_ID_KEY_NAME, (Object)groupId);
        this.groupId = groupId;
    }

    public GroupCoordinatorRequest(Struct struct, short versionId) {
        super(struct, versionId);
        this.groupId = struct.getString(GROUP_ID_KEY_NAME);
    }

    @Override
    public AbstractResponse getErrorResponse(Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                return new GroupCoordinatorResponse(Errors.GROUP_COORDINATOR_NOT_AVAILABLE.code(), Node.noNode());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.GROUP_COORDINATOR.id)));
    }

    public String groupId() {
        return this.groupId;
    }

    public static GroupCoordinatorRequest parse(ByteBuffer buffer, int versionId) {
        return new GroupCoordinatorRequest(ProtoUtils.parseRequest(ApiKeys.GROUP_COORDINATOR.id, versionId, buffer), (short)versionId);
    }

    public static GroupCoordinatorRequest parse(ByteBuffer buffer) {
        return GroupCoordinatorRequest.parse(buffer, ProtoUtils.latestVersion(ApiKeys.GROUP_COORDINATOR.id));
    }

    public static class Builder
    extends AbstractRequest.Builder<GroupCoordinatorRequest> {
        private final String groupId;

        public Builder(String groupId) {
            super(ApiKeys.GROUP_COORDINATOR);
            this.groupId = groupId;
        }

        @Override
        public GroupCoordinatorRequest build() {
            short version = this.version();
            return new GroupCoordinatorRequest(this.groupId, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=GroupCoordinatorRequest, groupId=");
            bld.append(this.groupId).append(")");
            return bld.toString();
        }
    }
}

