/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka010.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class DeleteTopicsResponse
extends AbstractResponse {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentResponseSchema(ApiKeys.DELETE_TOPICS.id);
    private static final String TOPIC_ERROR_CODES_KEY_NAME = "topic_error_codes";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private final Map<String, Errors> errors;

    public DeleteTopicsResponse(Map<String, Errors> errors) {
        super(new Struct(CURRENT_SCHEMA));
        ArrayList<Struct> topicErrorCodeStructs = new ArrayList<Struct>(errors.size());
        for (Map.Entry<String, Errors> topicError : errors.entrySet()) {
            Struct topicErrorCodeStruct = this.struct.instance(TOPIC_ERROR_CODES_KEY_NAME);
            topicErrorCodeStruct.set(TOPIC_KEY_NAME, (Object)topicError.getKey());
            topicErrorCodeStruct.set(ERROR_CODE_KEY_NAME, (Object)topicError.getValue().code());
            topicErrorCodeStructs.add(topicErrorCodeStruct);
        }
        this.struct.set(TOPIC_ERROR_CODES_KEY_NAME, (Object)topicErrorCodeStructs.toArray());
        this.errors = errors;
    }

    public DeleteTopicsResponse(Struct struct) {
        super(struct);
        Object[] topicErrorCodesStructs = struct.getArray(TOPIC_ERROR_CODES_KEY_NAME);
        HashMap<String, Errors> errors = new HashMap<String, Errors>();
        for (Object topicErrorCodeStructObj : topicErrorCodesStructs) {
            Struct topicErrorCodeStruct = (Struct)topicErrorCodeStructObj;
            String topic = topicErrorCodeStruct.getString(TOPIC_KEY_NAME);
            short errorCode = topicErrorCodeStruct.getShort(ERROR_CODE_KEY_NAME);
            errors.put(topic, Errors.forCode(errorCode));
        }
        this.errors = errors;
    }

    public Map<String, Errors> errors() {
        return this.errors;
    }

    public static DeleteTopicsResponse parse(ByteBuffer buffer) {
        return new DeleteTopicsResponse(CURRENT_SCHEMA.read(buffer));
    }

    public static DeleteTopicsResponse parse(ByteBuffer buffer, int version) {
        return new DeleteTopicsResponse(ProtoUtils.responseSchema(ApiKeys.DELETE_TOPICS.id, version).read(buffer));
    }
}

