/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka010.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.utils.Utils;

public class DeleteTopicsRequest
extends AbstractRequest {
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String TIMEOUT_KEY_NAME = "timeout";
    private final Set<String> topics;
    private final Integer timeout;

    private DeleteTopicsRequest(Set<String> topics, Integer timeout, short version) {
        super(new Struct(ProtoUtils.requestSchema(ApiKeys.DELETE_TOPICS.id, version)), version);
        this.struct.set(TOPICS_KEY_NAME, (Object)topics.toArray());
        this.struct.set(TIMEOUT_KEY_NAME, (Object)timeout);
        this.topics = topics;
        this.timeout = timeout;
    }

    public DeleteTopicsRequest(Struct struct, short version) {
        super(struct, version);
        Object[] topicsArray = struct.getArray(TOPICS_KEY_NAME);
        HashSet<String> topics = new HashSet<String>(topicsArray.length);
        for (Object topic : topicsArray) {
            topics.add((String)topic);
        }
        this.topics = topics;
        this.timeout = struct.getInt(TIMEOUT_KEY_NAME);
    }

    @Override
    public AbstractResponse getErrorResponse(Throwable e) {
        HashMap<String, Errors> topicErrors = new HashMap<String, Errors>();
        for (String topic : this.topics) {
            topicErrors.put(topic, Errors.forException(e));
        }
        switch (this.version()) {
            case 0: {
                return new DeleteTopicsResponse(topicErrors);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", this.version(), this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.DELETE_TOPICS.id)));
    }

    public Set<String> topics() {
        return this.topics;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public static DeleteTopicsRequest parse(ByteBuffer buffer, int versionId) {
        return new DeleteTopicsRequest(ProtoUtils.parseRequest(ApiKeys.DELETE_TOPICS.id, versionId, buffer), (short)versionId);
    }

    public static DeleteTopicsRequest parse(ByteBuffer buffer) {
        return DeleteTopicsRequest.parse(buffer, ProtoUtils.latestVersion(ApiKeys.DELETE_TOPICS.id));
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteTopicsRequest> {
        private final Set<String> topics;
        private final Integer timeout;

        public Builder(Set<String> topics, Integer timeout) {
            super(ApiKeys.DELETE_TOPICS);
            this.topics = topics;
            this.timeout = timeout;
        }

        @Override
        public DeleteTopicsRequest build() {
            return new DeleteTopicsRequest(this.topics, this.timeout, this.version());
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=DeleteTopicsRequest").append(", topics=(").append(Utils.join(this.topics, ", ")).append(")").append(", timeout=").append(this.timeout).append(")");
            return bld.toString();
        }
    }
}

