/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka010.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class CreateTopicsResponse
extends AbstractResponse {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentResponseSchema(ApiKeys.CREATE_TOPICS.id);
    private static final String TOPIC_ERRORS_KEY_NAME = "topic_errors";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private static final String ERROR_MESSAGE_KEY_NAME = "error_message";
    private final Map<String, Error> errors;

    public CreateTopicsResponse(Map<String, Error> errors, short version) {
        super(new Struct(ProtoUtils.responseSchema(ApiKeys.CREATE_TOPICS.id, version)));
        ArrayList<Struct> topicErrorsStructs = new ArrayList<Struct>(errors.size());
        for (Map.Entry<String, Error> topicError : errors.entrySet()) {
            Struct topicErrorsStruct = this.struct.instance(TOPIC_ERRORS_KEY_NAME);
            topicErrorsStruct.set(TOPIC_KEY_NAME, (Object)topicError.getKey());
            Error error = topicError.getValue();
            topicErrorsStruct.set(ERROR_CODE_KEY_NAME, (Object)error.error.code());
            if (version >= 1) {
                topicErrorsStruct.set(ERROR_MESSAGE_KEY_NAME, (Object)error.message());
            }
            topicErrorsStructs.add(topicErrorsStruct);
        }
        this.struct.set(TOPIC_ERRORS_KEY_NAME, (Object)topicErrorsStructs.toArray());
        this.errors = errors;
    }

    public CreateTopicsResponse(Struct struct) {
        super(struct);
        Object[] topicErrorStructs = struct.getArray(TOPIC_ERRORS_KEY_NAME);
        HashMap<String, Error> errors = new HashMap<String, Error>();
        for (Object topicErrorStructObj : topicErrorStructs) {
            Struct topicErrorCodeStruct = (Struct)topicErrorStructObj;
            String topic = topicErrorCodeStruct.getString(TOPIC_KEY_NAME);
            short errorCode = topicErrorCodeStruct.getShort(ERROR_CODE_KEY_NAME);
            String errorMessage = null;
            if (topicErrorCodeStruct.hasField(ERROR_MESSAGE_KEY_NAME)) {
                errorMessage = topicErrorCodeStruct.getString(ERROR_MESSAGE_KEY_NAME);
            }
            errors.put(topic, new Error(Errors.forCode(errorCode), errorMessage));
        }
        this.errors = errors;
    }

    public Map<String, Error> errors() {
        return this.errors;
    }

    public static CreateTopicsResponse parse(ByteBuffer buffer) {
        return new CreateTopicsResponse(CURRENT_SCHEMA.read(buffer));
    }

    public static CreateTopicsResponse parse(ByteBuffer buffer, int version) {
        return new CreateTopicsResponse(ProtoUtils.responseSchema(ApiKeys.CREATE_TOPICS.id, version).read(buffer));
    }

    public static class Error {
        private final Errors error;
        private final String message;

        public Error(Errors error, String message) {
            this.error = error;
            this.message = message;
        }

        public boolean is(Errors error) {
            return this.error == error;
        }

        public Errors error() {
            return this.error;
        }

        public String message() {
            return this.message;
        }

        public String messageWithFallback() {
            if (this.message == null) {
                return this.error.message();
            }
            return this.message;
        }

        public String toString() {
            return "Error(error=" + (Object)((Object)this.error) + ", message=" + this.message + ")";
        }
    }
}

