/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka010.shaded.org.apache.kafka.common.record;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends DataOutputStream {
    private static final float REALLOCATION_FACTOR = 1.1f;

    public ByteBufferOutputStream(ByteBuffer buffer) {
        super(new UnderlyingOutputStream(buffer));
    }

    public ByteBuffer buffer() {
        return ((UnderlyingOutputStream)this.out).buffer;
    }

    public static class UnderlyingOutputStream
    extends OutputStream {
        private ByteBuffer buffer;

        public UnderlyingOutputStream(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void write(int b) {
            if (this.buffer.remaining() < 1) {
                this.expandBuffer(this.buffer.capacity() + 1);
            }
            this.buffer.put((byte)b);
        }

        @Override
        public void write(byte[] bytes, int off, int len) {
            if (this.buffer.remaining() < len) {
                this.expandBuffer(this.buffer.capacity() + len);
            }
            this.buffer.put(bytes, off, len);
        }

        public ByteBuffer buffer() {
            return this.buffer;
        }

        private void expandBuffer(int size) {
            int expandSize = Math.max((int)((float)this.buffer.capacity() * 1.1f), size);
            ByteBuffer temp = ByteBuffer.allocate(expandSize);
            temp.put(this.buffer.array(), this.buffer.arrayOffset(), this.buffer.position());
            this.buffer = temp;
        }
    }
}

