/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol;

public enum ApiKeys {
    PRODUCE(0, "Produce"),
    FETCH(1, "Fetch"),
    LIST_OFFSETS(2, "Offsets"),
    METADATA(3, "Metadata"),
    LEADER_AND_ISR(4, "LeaderAndIsr"),
    STOP_REPLICA(5, "StopReplica"),
    UPDATE_METADATA_KEY(6, "UpdateMetadata"),
    CONTROLLED_SHUTDOWN_KEY(7, "ControlledShutdown"),
    OFFSET_COMMIT(8, "OffsetCommit"),
    OFFSET_FETCH(9, "OffsetFetch"),
    GROUP_COORDINATOR(10, "GroupCoordinator"),
    JOIN_GROUP(11, "JoinGroup"),
    HEARTBEAT(12, "Heartbeat"),
    LEAVE_GROUP(13, "LeaveGroup"),
    SYNC_GROUP(14, "SyncGroup"),
    DESCRIBE_GROUPS(15, "DescribeGroups"),
    LIST_GROUPS(16, "ListGroups"),
    SASL_HANDSHAKE(17, "SaslHandshake"),
    API_VERSIONS(18, "ApiVersions"),
    CREATE_TOPICS(19, "CreateTopics"),
    DELETE_TOPICS(20, "DeleteTopics");

    private static final ApiKeys[] ID_TO_TYPE;
    private static final int MIN_API_KEY = 0;
    public static final int MAX_API_KEY;
    public final short id;
    public final String name;

    private ApiKeys(int id, String name) {
        this.id = (short)id;
        this.name = name;
    }

    public static ApiKeys forId(int id) {
        if (!ApiKeys.hasId(id)) {
            throw new IllegalArgumentException(String.format("Unexpected ApiKeys id `%s`, it should be between `%s` and `%s` (inclusive)", id, 0, MAX_API_KEY));
        }
        return ID_TO_TYPE[id];
    }

    public static boolean hasId(int id) {
        return id >= 0 && id <= MAX_API_KEY;
    }

    private static String toHtml() {
        StringBuilder b = new StringBuilder();
        b.append("<table class=\"data-table\"><tbody>\n");
        b.append("<tr>");
        b.append("<th>Name</th>\n");
        b.append("<th>Key</th>\n");
        b.append("</tr>");
        for (ApiKeys key : ApiKeys.values()) {
            b.append("<tr>\n");
            b.append("<td>");
            b.append("<a href=\"#The_Messages_" + key.name + "\">" + key.name + "</a>");
            b.append("</td>");
            b.append("<td>");
            b.append(key.id);
            b.append("</td>");
            b.append("</tr>\n");
        }
        b.append("</table>\n");
        return b.toString();
    }

    public static void main(String[] args) {
        System.out.println(ApiKeys.toHtml());
    }

    static {
        int maxKey = -1;
        for (ApiKeys key : ApiKeys.values()) {
            maxKey = Math.max(maxKey, key.id);
        }
        ApiKeys[] idToType = new ApiKeys[maxKey + 1];
        ApiKeys[] arr$ = ApiKeys.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ApiKeys key;
            idToType[key.id] = key = arr$[i$];
        }
        ID_TO_TYPE = idToType;
        MAX_API_KEY = maxKey;
    }
}

