/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka010.shaded.org.apache.kafka.common.network;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Map;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.KafkaException;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.network.ChannelBuilder;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.network.ChannelBuilders;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.network.DefaultAuthenticator;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.network.KafkaChannel;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.network.Mode;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.network.SslTransportLayer;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.security.auth.PrincipalBuilder;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.security.ssl.SslFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslChannelBuilder
implements ChannelBuilder {
    private static final Logger log = LoggerFactory.getLogger(SslChannelBuilder.class);
    private SslFactory sslFactory;
    private PrincipalBuilder principalBuilder;
    private Mode mode;
    private Map<String, ?> configs;

    public SslChannelBuilder(Mode mode) {
        this.mode = mode;
    }

    @Override
    public void configure(Map<String, ?> configs) throws KafkaException {
        try {
            this.configs = configs;
            this.sslFactory = new SslFactory(this.mode);
            this.sslFactory.configure(this.configs);
            this.principalBuilder = ChannelBuilders.createPrincipalBuilder(configs);
        }
        catch (Exception e) {
            throw new KafkaException(e);
        }
    }

    @Override
    public KafkaChannel buildChannel(String id, SelectionKey key, int maxReceiveSize) throws KafkaException {
        try {
            SslTransportLayer transportLayer = this.buildTransportLayer(this.sslFactory, id, key);
            DefaultAuthenticator authenticator = new DefaultAuthenticator();
            authenticator.configure(transportLayer, this.principalBuilder, this.configs);
            return new KafkaChannel(id, transportLayer, authenticator, maxReceiveSize);
        }
        catch (Exception e) {
            log.info("Failed to create channel due to ", (Throwable)e);
            throw new KafkaException(e);
        }
    }

    @Override
    public void close() {
        this.principalBuilder.close();
    }

    protected SslTransportLayer buildTransportLayer(SslFactory sslFactory, String id, SelectionKey key) throws IOException {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        return SslTransportLayer.create(id, key, sslFactory.createSslEngine(socketChannel.socket().getInetAddress().getHostName(), socketChannel.socket().getPort()));
    }
}

