/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka010.shaded.org.apache.kafka.common.network;

import java.nio.channels.SelectionKey;
import java.util.Map;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.KafkaException;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.network.ChannelBuilder;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.network.ChannelBuilders;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.network.DefaultAuthenticator;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.network.KafkaChannel;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.network.PlaintextTransportLayer;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.security.auth.PrincipalBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaintextChannelBuilder
implements ChannelBuilder {
    private static final Logger log = LoggerFactory.getLogger(PlaintextChannelBuilder.class);
    private PrincipalBuilder principalBuilder;
    private Map<String, ?> configs;

    @Override
    public void configure(Map<String, ?> configs) throws KafkaException {
        try {
            this.configs = configs;
            this.principalBuilder = ChannelBuilders.createPrincipalBuilder(configs);
        }
        catch (Exception e) {
            throw new KafkaException(e);
        }
    }

    @Override
    public KafkaChannel buildChannel(String id, SelectionKey key, int maxReceiveSize) throws KafkaException {
        try {
            PlaintextTransportLayer transportLayer = new PlaintextTransportLayer(key);
            DefaultAuthenticator authenticator = new DefaultAuthenticator();
            authenticator.configure(transportLayer, this.principalBuilder, this.configs);
            return new KafkaChannel(id, transportLayer, authenticator, maxReceiveSize);
        }
        catch (Exception e) {
            log.warn("Failed to create channel due to ", (Throwable)e);
            throw new KafkaException(e);
        }
    }

    @Override
    public void close() {
        this.principalBuilder.close();
    }
}

