/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka010.shaded.org.apache.kafka.clients.producer.internals;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.kafka010.shaded.org.apache.kafka.clients.producer.Callback;
import org.apache.flink.kafka010.shaded.org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.flink.kafka010.shaded.org.apache.kafka.clients.producer.internals.FutureRecordMetadata;
import org.apache.flink.kafka010.shaded.org.apache.kafka.clients.producer.internals.ProduceRequestResult;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.errors.TimeoutException;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.record.MemoryRecords;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.record.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RecordBatch {
    private static final Logger log = LoggerFactory.getLogger(RecordBatch.class);
    final long createdMs;
    final TopicPartition topicPartition;
    final ProduceRequestResult produceFuture;
    private final List<Thunk> thunks = new ArrayList<Thunk>();
    private final MemoryRecordsBuilder recordsBuilder;
    volatile int attempts;
    int recordCount;
    int maxRecordSize;
    long drainedMs;
    long lastAttemptMs;
    long lastAppendTime;
    private String expiryErrorMessage;
    private AtomicBoolean completed;
    private boolean retry;

    public RecordBatch(TopicPartition tp, MemoryRecordsBuilder recordsBuilder, long now) {
        this.createdMs = now;
        this.lastAttemptMs = now;
        this.recordsBuilder = recordsBuilder;
        this.topicPartition = tp;
        this.lastAppendTime = this.createdMs;
        this.produceFuture = new ProduceRequestResult(this.topicPartition);
        this.completed = new AtomicBoolean();
    }

    public FutureRecordMetadata tryAppend(long timestamp, byte[] key, byte[] value, Callback callback, long now) {
        if (!this.recordsBuilder.hasRoomFor(key, value)) {
            return null;
        }
        long checksum = this.recordsBuilder.append(timestamp, key, value);
        this.maxRecordSize = Math.max(this.maxRecordSize, Record.recordSize(key, value));
        this.lastAppendTime = now;
        FutureRecordMetadata future = new FutureRecordMetadata(this.produceFuture, this.recordCount, timestamp, checksum, key == null ? -1 : key.length, value == null ? -1 : value.length);
        if (callback != null) {
            this.thunks.add(new Thunk(callback, future));
        }
        ++this.recordCount;
        return future;
    }

    public void done(long baseOffset, long logAppendTime, RuntimeException exception) {
        log.trace("Produced messages to topic-partition {} with base offset offset {} and error: {}.", new Object[]{this.topicPartition, baseOffset, exception});
        if (this.completed.getAndSet(true)) {
            throw new IllegalStateException("Batch has already been completed");
        }
        this.produceFuture.set(baseOffset, logAppendTime, exception);
        for (Thunk thunk : this.thunks) {
            try {
                if (exception == null) {
                    RecordMetadata metadata = thunk.future.value();
                    thunk.callback.onCompletion(metadata, null);
                    continue;
                }
                thunk.callback.onCompletion(null, exception);
            }
            catch (Exception e) {
                log.error("Error executing user-provided callback on message for topic-partition '{}'", (Object)this.topicPartition, (Object)e);
            }
        }
        this.produceFuture.done();
    }

    public String toString() {
        return "RecordBatch(topicPartition=" + this.topicPartition + ", recordCount=" + this.recordCount + ")";
    }

    public boolean maybeExpire(int requestTimeoutMs, long retryBackoffMs, long now, long lingerMs, boolean isFull) {
        boolean expired;
        if (!this.inRetry() && isFull && (long)requestTimeoutMs < now - this.lastAppendTime) {
            this.expiryErrorMessage = now - this.lastAppendTime + " ms has passed since last append";
        } else if (!this.inRetry() && (long)requestTimeoutMs < now - (this.createdMs + lingerMs)) {
            this.expiryErrorMessage = now - (this.createdMs + lingerMs) + " ms has passed since batch creation plus linger time";
        } else if (this.inRetry() && (long)requestTimeoutMs < now - (this.lastAttemptMs + retryBackoffMs)) {
            this.expiryErrorMessage = now - (this.lastAttemptMs + retryBackoffMs) + " ms has passed since last attempt plus backoff time";
        }
        boolean bl = expired = this.expiryErrorMessage != null;
        if (expired) {
            this.close();
        }
        return expired;
    }

    void expirationDone() {
        if (this.expiryErrorMessage == null) {
            throw new IllegalStateException("Batch has not expired");
        }
        this.done(-1L, -1L, new TimeoutException("Expiring " + this.recordCount + " record(s) for " + this.topicPartition + ": " + this.expiryErrorMessage));
    }

    private boolean inRetry() {
        return this.retry;
    }

    public void setRetry() {
        this.retry = true;
    }

    public MemoryRecords records() {
        return this.recordsBuilder.build();
    }

    public int sizeInBytes() {
        return this.recordsBuilder.sizeInBytes();
    }

    public double compressionRate() {
        return this.recordsBuilder.compressionRate();
    }

    public boolean isFull() {
        return this.recordsBuilder.isFull();
    }

    public void close() {
        this.recordsBuilder.close();
    }

    public ByteBuffer buffer() {
        return this.recordsBuilder.buffer();
    }

    public int initialCapacity() {
        return this.recordsBuilder.initialCapacity();
    }

    public boolean isWritable() {
        return !this.recordsBuilder.isClosed();
    }

    private static final class Thunk {
        final Callback callback;
        final FutureRecordMetadata future;

        public Thunk(Callback callback, FutureRecordMetadata future) {
            this.callback = callback;
            this.future = future;
        }
    }
}

