/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka010.shaded.org.apache.kafka.clients.producer.internals;

import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.kafka010.shaded.org.apache.kafka.clients.producer.Partitioner;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.Cluster;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.PartitionInfo;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.utils.Utils;

public class DefaultPartitioner
implements Partitioner {
    private final ConcurrentMap<String, AtomicInteger> topicCounterMap = new ConcurrentHashMap<String, AtomicInteger>();

    @Override
    public void configure(Map<String, ?> configs) {
    }

    @Override
    public int partition(String topic, Object key, byte[] keyBytes, Object value, byte[] valueBytes, Cluster cluster) {
        List<PartitionInfo> partitions = cluster.partitionsForTopic(topic);
        int numPartitions = partitions.size();
        if (keyBytes == null) {
            int nextValue = this.nextValue(topic);
            List<PartitionInfo> availablePartitions = cluster.availablePartitionsForTopic(topic);
            if (availablePartitions.size() > 0) {
                int part = Utils.toPositive(nextValue) % availablePartitions.size();
                return availablePartitions.get(part).partition();
            }
            return Utils.toPositive(nextValue) % numPartitions;
        }
        return Utils.toPositive(Utils.murmur2(keyBytes)) % numPartitions;
    }

    private int nextValue(String topic) {
        AtomicInteger currentCounter;
        AtomicInteger counter = (AtomicInteger)this.topicCounterMap.get(topic);
        if (null == counter && (currentCounter = this.topicCounterMap.putIfAbsent(topic, counter = new AtomicInteger(new Random().nextInt()))) != null) {
            counter = currentCounter;
        }
        return counter.getAndIncrement();
    }

    @Override
    public void close() {
    }
}

