/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.io.File;
import java.net.BindException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import kafka.admin.AdminUtils;
import kafka.admin.RackAwareMode;
import kafka.common.KafkaException;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.ZkUtils;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.commons.collections.list.UnmodifiableList;
import org.apache.commons.io.FileUtils;
import org.apache.curator.test.TestingServer;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumer010;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumerBase;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaProducer010;
import org.apache.flink.streaming.connectors.kafka.KafkaTestEnvironment;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import org.apache.flink.streaming.connectors.kafka.testutils.ZooKeeperStringSerializer;
import org.apache.flink.streaming.util.serialization.KeyedDeserializationSchema;
import org.apache.flink.streaming.util.serialization.KeyedSerializationSchema;
import org.apache.flink.util.NetUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.Seq;
import scala.collection.mutable.ArraySeq;

public class KafkaTestEnvironmentImpl
extends KafkaTestEnvironment {
    protected static final Logger LOG = LoggerFactory.getLogger(KafkaTestEnvironmentImpl.class);
    private File tmpZkDir;
    private File tmpKafkaParent;
    private List<File> tmpKafkaDirs;
    private List<KafkaServer> brokers;
    private TestingServer zookeeper;
    private String zookeeperConnectionString;
    private String brokerConnectionString = "";
    private Properties standardProps;
    private Properties additionalServerProperties;
    private boolean secureMode = false;
    private int zkTimeout = 30000;

    public String getBrokerConnectionString() {
        return this.brokerConnectionString;
    }

    public Properties getStandardProperties() {
        return this.standardProps;
    }

    public Properties getSecureProperties() {
        Properties prop = new Properties();
        if (this.secureMode) {
            prop.put("security.inter.broker.protocol", "SASL_PLAINTEXT");
            prop.put("security.protocol", "SASL_PLAINTEXT");
            prop.put("sasl.kerberos.service.name", "kafka");
            prop.setProperty("zookeeper.session.timeout.ms", String.valueOf(this.zkTimeout));
            prop.setProperty("zookeeper.connection.timeout.ms", String.valueOf(this.zkTimeout));
            prop.setProperty("metadata.fetch.timeout.ms", "120000");
        }
        return prop;
    }

    public String getVersion() {
        return "0.10";
    }

    public List<KafkaServer> getBrokers() {
        return this.brokers;
    }

    public <T> FlinkKafkaConsumerBase<T> getConsumer(List<String> topics, KeyedDeserializationSchema<T> readSchema, Properties props) {
        return new FlinkKafkaConsumer010(topics, readSchema, props);
    }

    public <K, V> Collection<ConsumerRecord<K, V>> getAllRecordsFromTopic(Properties properties, String topic, int partition, long timeout) {
        boolean processedAtLeastOneRecord;
        ArrayList<ConsumerRecord> result = new ArrayList<ConsumerRecord>();
        KafkaConsumer consumer = new KafkaConsumer(properties);
        consumer.assign(Arrays.asList(new TopicPartition(topic, partition)));
        do {
            processedAtLeastOneRecord = false;
            for (ConsumerRecord record : consumer.poll(timeout)) {
                result.add(record);
                processedAtLeastOneRecord = true;
            }
        } while (processedAtLeastOneRecord);
        return UnmodifiableList.decorate(result);
    }

    public <T> StreamSink<T> getProducerSink(String topic, KeyedSerializationSchema<T> serSchema, Properties props, FlinkKafkaPartitioner<T> partitioner) {
        FlinkKafkaProducer010 prod = new FlinkKafkaProducer010(topic, serSchema, props, partitioner);
        prod.setFlushOnCheckpoint(true);
        return new StreamSink((SinkFunction)prod);
    }

    public <T> DataStreamSink<T> produceIntoKafka(DataStream<T> stream, String topic, KeyedSerializationSchema<T> serSchema, Properties props, FlinkKafkaPartitioner<T> partitioner) {
        FlinkKafkaProducer010 prod = new FlinkKafkaProducer010(topic, serSchema, props, partitioner);
        prod.setFlushOnCheckpoint(true);
        return stream.addSink((SinkFunction)prod);
    }

    public <T> DataStreamSink<T> writeToKafkaWithTimestamps(DataStream<T> stream, String topic, KeyedSerializationSchema<T> serSchema, Properties props) {
        return FlinkKafkaProducer010.writeToKafkaWithTimestamps(stream, (String)topic, serSchema, (Properties)props);
    }

    public KafkaTestEnvironment.KafkaOffsetHandler createOffsetHandler() {
        return new KafkaOffsetHandlerImpl();
    }

    public void restartBroker(int leaderId) throws Exception {
        this.brokers.set(leaderId, this.getKafkaServer(leaderId, this.tmpKafkaDirs.get(leaderId)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLeaderToShutDown(String topic) throws Exception {
        try (ZkUtils zkUtils = this.getZkUtils();){
            List partitionMetadata;
            MetadataResponse.PartitionMetadata firstPart = null;
            do {
                if (firstPart == null) continue;
                LOG.info("Unable to find leader. error code {}", (Object)firstPart.error().code());
                Thread.sleep(150L);
            } while ((firstPart = (MetadataResponse.PartitionMetadata)(partitionMetadata = AdminUtils.fetchTopicMetadataFromZk((String)topic, (ZkUtils)zkUtils).partitionMetadata()).get(0)).error().code() != 0);
            int n = firstPart.leader().id();
            return n;
        }
    }

    public int getBrokerId(KafkaServer server) {
        return server.config().brokerId();
    }

    public boolean isSecureRunSupported() {
        return true;
    }

    public void prepare(int numKafkaServers, Properties additionalServerProperties, boolean secureMode) {
        int i;
        if (secureMode) {
            numKafkaServers = 1;
            this.zkTimeout *= 15;
        }
        this.additionalServerProperties = additionalServerProperties;
        this.secureMode = secureMode;
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        this.tmpZkDir = new File(tempDir, "kafkaITcase-zk-dir-" + UUID.randomUUID().toString());
        Assert.assertTrue((String)"cannot create zookeeper temp dir", (boolean)this.tmpZkDir.mkdirs());
        this.tmpKafkaParent = new File(tempDir, "kafkaITcase-kafka-dir*" + UUID.randomUUID().toString());
        Assert.assertTrue((String)"cannot create kafka temp dir", (boolean)this.tmpKafkaParent.mkdirs());
        this.tmpKafkaDirs = new ArrayList<File>(numKafkaServers);
        for (i = 0; i < numKafkaServers; ++i) {
            File tmpDir = new File(this.tmpKafkaParent, "server-" + i);
            Assert.assertTrue((String)"cannot create kafka temp dir", (boolean)tmpDir.mkdir());
            this.tmpKafkaDirs.add(tmpDir);
        }
        this.zookeeper = null;
        this.brokers = null;
        try {
            this.zookeeper = new TestingServer(-1, this.tmpZkDir);
            this.zookeeperConnectionString = this.zookeeper.getConnectString();
            LOG.info("Starting Zookeeper with zookeeperConnectionString: {}", (Object)this.zookeeperConnectionString);
            LOG.info("Starting KafkaServer");
            this.brokers = new ArrayList<KafkaServer>(numKafkaServers);
            for (i = 0; i < numKafkaServers; ++i) {
                this.brokers.add(this.getKafkaServer(i, this.tmpKafkaDirs.get(i)));
                this.brokerConnectionString = secureMode ? this.brokerConnectionString + NetUtils.hostAndPortToUrlString((String)"localhost", (int)this.brokers.get(i).socketServer().boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT))) : this.brokerConnectionString + NetUtils.hostAndPortToUrlString((String)"localhost", (int)this.brokers.get(i).socketServer().boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT)));
                this.brokerConnectionString = this.brokerConnectionString + ",";
            }
            LOG.info("ZK and KafkaServer started.");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)("Test setup failed: " + t.getMessage()));
        }
        this.standardProps = new Properties();
        this.standardProps.setProperty("zookeeper.connect", this.zookeeperConnectionString);
        this.standardProps.setProperty("bootstrap.servers", this.brokerConnectionString);
        this.standardProps.setProperty("group.id", "flink-tests");
        this.standardProps.setProperty("enable.auto.commit", "false");
        this.standardProps.setProperty("zookeeper.session.timeout.ms", String.valueOf(this.zkTimeout));
        this.standardProps.setProperty("zookeeper.connection.timeout.ms", String.valueOf(this.zkTimeout));
        this.standardProps.setProperty("auto.offset.reset", "earliest");
        this.standardProps.setProperty("max.partition.fetch.bytes", "256");
    }

    public void shutdown() {
        for (KafkaServer broker : this.brokers) {
            if (broker == null) continue;
            broker.shutdown();
        }
        this.brokers.clear();
        if (this.zookeeper != null) {
            try {
                this.zookeeper.stop();
            }
            catch (Exception e) {
                LOG.warn("ZK.stop() failed", (Throwable)e);
            }
            this.zookeeper = null;
        }
        if (this.tmpKafkaParent != null && this.tmpKafkaParent.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.tmpKafkaParent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.tmpZkDir != null && this.tmpZkDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.tmpZkDir);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ZkUtils getZkUtils() {
        ZkClient creator = new ZkClient(this.zookeeperConnectionString, Integer.valueOf(this.standardProps.getProperty("zookeeper.session.timeout.ms")).intValue(), Integer.valueOf(this.standardProps.getProperty("zookeeper.connection.timeout.ms")).intValue(), (ZkSerializer)new ZooKeeperStringSerializer());
        return ZkUtils.apply((ZkClient)creator, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTestTopic(String topic, int numberOfPartitions, int replicationFactor, Properties topicConfig) {
        LOG.info("Creating topic {}", (Object)topic);
        try (ZkUtils zkUtils = this.getZkUtils();){
            AdminUtils.createTopic((ZkUtils)zkUtils, (String)topic, (int)numberOfPartitions, (int)replicationFactor, (Properties)topicConfig, (RackAwareMode)RackAwareMode.Enforced$.MODULE$);
        }
        long deadline = System.nanoTime() + 30000000000L;
        do {
            try {
                if (this.secureMode) {
                    int wait = this.zkTimeout / 100;
                    LOG.info("waiting for {} msecs before the topic {} can be checked", (Object)wait, (Object)topic);
                    Thread.sleep(wait);
                } else {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException wait) {
                // empty catch block
            }
            ZkUtils checkZKConn = this.getZkUtils();
            if (AdminUtils.topicExists((ZkUtils)checkZKConn, (String)topic)) {
                checkZKConn.close();
                return;
            }
            checkZKConn.close();
        } while (System.nanoTime() < deadline);
        Assert.fail((String)"Test topic could not be created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTestTopic(String topic) {
        try (ZkUtils zkUtils = this.getZkUtils();){
            LOG.info("Deleting topic {}", (Object)topic);
            ZkClient zk = new ZkClient(this.zookeeperConnectionString, Integer.valueOf(this.standardProps.getProperty("zookeeper.session.timeout.ms")).intValue(), Integer.valueOf(this.standardProps.getProperty("zookeeper.connection.timeout.ms")).intValue(), (ZkSerializer)new ZooKeeperStringSerializer());
            AdminUtils.deleteTopic((ZkUtils)zkUtils, (String)topic);
            zk.close();
        }
    }

    protected KafkaServer getKafkaServer(int brokerId, File tmpFolder) throws Exception {
        Properties kafkaProperties = new Properties();
        kafkaProperties.put("advertised.host.name", "localhost");
        kafkaProperties.put("broker.id", Integer.toString(brokerId));
        kafkaProperties.put("log.dir", tmpFolder.toString());
        kafkaProperties.put("zookeeper.connect", this.zookeeperConnectionString);
        kafkaProperties.put("message.max.bytes", String.valueOf(0x3200000));
        kafkaProperties.put("replica.fetch.max.bytes", String.valueOf(0x3200000));
        kafkaProperties.put("zookeeper.session.timeout.ms", (Object)this.zkTimeout);
        kafkaProperties.put("zookeeper.connection.timeout.ms", (Object)this.zkTimeout);
        if (this.additionalServerProperties != null) {
            kafkaProperties.putAll((Map<?, ?>)this.additionalServerProperties);
        }
        int numTries = 5;
        for (int i = 1; i <= 5; ++i) {
            int kafkaPort = NetUtils.getAvailablePort();
            kafkaProperties.put("port", Integer.toString(kafkaPort));
            if (this.secureMode) {
                LOG.info("Adding Kafka secure configurations");
                kafkaProperties.put("listeners", "SASL_PLAINTEXT://localhost:" + kafkaPort);
                kafkaProperties.put("advertised.listeners", "SASL_PLAINTEXT://localhost:" + kafkaPort);
                kafkaProperties.putAll((Map<?, ?>)this.getSecureProperties());
            }
            KafkaConfig kafkaConfig = new KafkaConfig((Map)kafkaProperties);
            try {
                Option stringNone = Option.apply(null);
                KafkaServer server = new KafkaServer(kafkaConfig, Time.SYSTEM, stringNone, (Seq)new ArraySeq(0));
                server.startup();
                return server;
            }
            catch (KafkaException e) {
                if (!(e.getCause() instanceof BindException)) {
                    throw e;
                }
                LOG.info("Port conflict when starting Kafka Broker. Retrying...");
                continue;
            }
        }
        throw new Exception("Could not start Kafka after 5 retries due to port conflicts.");
    }

    private class KafkaOffsetHandlerImpl
    implements KafkaTestEnvironment.KafkaOffsetHandler {
        private final KafkaConsumer<byte[], byte[]> offsetClient;

        public KafkaOffsetHandlerImpl() {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)KafkaTestEnvironmentImpl.this.standardProps);
            props.setProperty("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
            props.setProperty("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
            this.offsetClient = new KafkaConsumer(props);
        }

        public Long getCommittedOffset(String topicName, int partition) {
            OffsetAndMetadata committed = this.offsetClient.committed(new TopicPartition(topicName, partition));
            return committed != null ? Long.valueOf(committed.offset()) : null;
        }

        public void setCommittedOffset(String topicName, int partition, long offset) {
            HashMap<TopicPartition, OffsetAndMetadata> partitionAndOffset = new HashMap<TopicPartition, OffsetAndMetadata>();
            partitionAndOffset.put(new TopicPartition(topicName, partition), new OffsetAndMetadata(offset));
            this.offsetClient.commitSync(partitionAndOffset);
        }

        public void close() {
            this.offsetClient.close();
        }
    }
}

