/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.descriptors.ConnectorDescriptorValidator;
import org.apache.flink.table.descriptors.DescriptorProperties;

@Internal
public class HBaseValidator
extends ConnectorDescriptorValidator {
    public static final String CONNECTOR_TYPE_VALUE_HBASE = "hbase";
    public static final String CONNECTOR_VERSION_VALUE_143 = "1.4.3";
    public static final String CONNECTOR_TABLE_NAME = "connector.table-name";
    public static final String CONNECTOR_ZK_QUORUM = "connector.zookeeper.quorum";
    public static final String CONNECTOR_ZK_NODE_PARENT = "connector.zookeeper.znode.parent";
    public static final String CONNECTOR_WRITE_BUFFER_FLUSH_MAX_SIZE = "connector.write.buffer-flush.max-size";
    public static final String CONNECTOR_WRITE_BUFFER_FLUSH_MAX_ROWS = "connector.write.buffer-flush.max-rows";
    public static final String CONNECTOR_WRITE_BUFFER_FLUSH_INTERVAL = "connector.write.buffer-flush.interval";

    public void validate(DescriptorProperties properties) {
        super.validate(properties);
        properties.validateValue("connector.type", CONNECTOR_TYPE_VALUE_HBASE, false);
        properties.validateString(CONNECTOR_TABLE_NAME, false, 1);
        properties.validateString(CONNECTOR_ZK_QUORUM, false, 1);
        properties.validateString(CONNECTOR_ZK_NODE_PARENT, true, 1);
        this.validateSinkProperties(properties);
        this.validateVersion(properties);
    }

    private void validateSinkProperties(DescriptorProperties properties) {
        properties.validateMemorySize(CONNECTOR_WRITE_BUFFER_FLUSH_MAX_SIZE, true, 0x100000);
        properties.validateInt(CONNECTOR_WRITE_BUFFER_FLUSH_MAX_ROWS, true, 1);
        properties.validateDuration(CONNECTOR_WRITE_BUFFER_FLUSH_INTERVAL, true, 1);
    }

    private void validateVersion(DescriptorProperties properties) {
        List<String> versions = Arrays.asList(CONNECTOR_VERSION_VALUE_143);
        properties.validateEnumValues("connector.version", false, versions);
    }
}

