/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase.source;

import java.io.IOException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.hbase.source.AbstractTableInputFormat;
import org.apache.flink.connector.hbase.util.HBaseSerde;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseRowDataInputFormat
extends AbstractTableInputFormat<RowData> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HBaseRowDataInputFormat.class);
    private final String tableName;
    private final HBaseTableSchema schema;
    private final String nullStringLiteral;
    private transient HBaseSerde serde;

    public HBaseRowDataInputFormat(org.apache.hadoop.conf.Configuration conf, String tableName, HBaseTableSchema schema, String nullStringLiteral) {
        super(conf);
        this.tableName = tableName;
        this.schema = schema;
        this.nullStringLiteral = nullStringLiteral;
    }

    @Override
    public void configure(Configuration parameters) {
        LOG.info("Initializing HBase configuration.");
        this.serde = new HBaseSerde(this.schema, this.nullStringLiteral);
        this.connectToTable();
        if (this.table != null) {
            this.scan = this.getScanner();
        }
    }

    @Override
    protected Scan getScanner() {
        return this.serde.createScan();
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    protected RowData mapResultToOutType(Result res) {
        return this.serde.convertToRow(res);
    }

    private void connectToTable() {
        try {
            Connection conn = ConnectionFactory.createConnection((org.apache.hadoop.conf.Configuration)this.getHadoopConfiguration());
            this.table = (HTable)conn.getTable(TableName.valueOf((String)this.tableName));
        }
        catch (TableNotFoundException tnfe) {
            LOG.error("The table " + this.tableName + " not found ", (Throwable)tnfe);
            throw new RuntimeException("HBase table '" + this.tableName + "' not found.", tnfe);
        }
        catch (IOException ioe) {
            LOG.error("Exception while creating connection to HBase.", (Throwable)ioe);
            throw new RuntimeException("Cannot create connection to HBase.", ioe);
        }
    }
}

