/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase.source;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.LocatableInputSplitAssigner;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.hbase.source.TableInputSplit;
import org.apache.flink.connector.hbase.util.HBaseConfigurationUtil;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.core.io.LocatableInputSplit;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
abstract class AbstractTableInputFormat<T>
extends RichInputFormat<T, TableInputSplit> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractTableInputFormat.class);
    private static final long serialVersionUID = 1L;
    protected boolean endReached = false;
    protected transient HTable table = null;
    protected transient Scan scan = null;
    protected ResultScanner resultScanner = null;
    protected byte[] currentRow;
    protected long scannedRows;
    protected byte[] serializedConfig;

    public AbstractTableInputFormat(org.apache.hadoop.conf.Configuration hConf) {
        this.serializedConfig = HBaseConfigurationUtil.serializeConfiguration(hConf);
    }

    protected abstract Scan getScanner();

    protected abstract String getTableName();

    protected abstract T mapResultToOutType(Result var1);

    public abstract void configure(Configuration var1);

    protected org.apache.hadoop.conf.Configuration getHadoopConfiguration() {
        return HBaseConfigurationUtil.deserializeConfiguration(this.serializedConfig, HBaseConfiguration.create());
    }

    public void open(TableInputSplit split) throws IOException {
        if (this.table == null) {
            throw new IOException("The HBase table has not been opened! This needs to be done in configure().");
        }
        if (this.scan == null) {
            throw new IOException("Scan has not been initialized! This needs to be done in configure().");
        }
        if (split == null) {
            throw new IOException("Input split is null!");
        }
        this.logSplitInfo("opening", split);
        this.currentRow = split.getStartRow();
        this.scan.setStartRow(this.currentRow);
        this.scan.setStopRow(split.getEndRow());
        this.resultScanner = this.table.getScanner(this.scan);
        this.endReached = false;
        this.scannedRows = 0L;
    }

    public T nextRecord(T reuse) throws IOException {
        Result res;
        if (this.resultScanner == null) {
            throw new IOException("No table result scanner provided!");
        }
        try {
            res = this.resultScanner.next();
        }
        catch (Exception e) {
            this.resultScanner.close();
            LOG.warn("Error after scan of " + this.scannedRows + " rows. Retry with a new scanner...", (Throwable)e);
            this.scan.withStartRow(this.currentRow, false);
            this.resultScanner = this.table.getScanner(this.scan);
            res = this.resultScanner.next();
        }
        if (res != null) {
            ++this.scannedRows;
            this.currentRow = res.getRow();
            return this.mapResultToOutType(res);
        }
        this.endReached = true;
        return null;
    }

    private void logSplitInfo(String action, TableInputSplit split) {
        int splitId = split.getSplitNumber();
        String splitStart = Bytes.toString((byte[])split.getStartRow());
        String splitEnd = Bytes.toString((byte[])split.getEndRow());
        String splitStartKey = splitStart.isEmpty() ? "-" : splitStart;
        String splitStopKey = splitEnd.isEmpty() ? "-" : splitEnd;
        String[] hostnames = split.getHostnames();
        LOG.info("{} split (this={})[{}|{}|{}|{}]", new Object[]{action, this, splitId, hostnames, splitStartKey, splitStopKey});
    }

    public boolean reachedEnd() throws IOException {
        return this.endReached;
    }

    public void close() throws IOException {
        LOG.info("Closing split (scanned {} rows)", (Object)this.scannedRows);
        this.currentRow = null;
        try {
            if (this.resultScanner != null) {
                this.resultScanner.close();
            }
        }
        finally {
            this.resultScanner = null;
        }
    }

    public void closeInputFormat() throws IOException {
        try {
            if (this.table != null) {
                this.table.close();
            }
        }
        finally {
            this.table = null;
        }
    }

    public TableInputSplit[] createInputSplits(int minNumSplits) throws IOException {
        if (this.table == null) {
            throw new IOException("The HBase table has not been opened! This needs to be done in configure().");
        }
        if (this.scan == null) {
            throw new IOException("Scan has not been initialized! This needs to be done in configure().");
        }
        Pair keys = this.table.getRegionLocator().getStartEndKeys();
        if (keys == null || keys.getFirst() == null || ((byte[][])keys.getFirst()).length == 0) {
            throw new IOException("Expecting at least one region.");
        }
        byte[] startRow = this.scan.getStartRow();
        byte[] stopRow = this.scan.getStopRow();
        boolean scanWithNoLowerBound = startRow.length == 0;
        boolean scanWithNoUpperBound = stopRow.length == 0;
        ArrayList<TableInputSplit> splits = new ArrayList<TableInputSplit>(minNumSplits);
        for (int i = 0; i < ((byte[][])keys.getFirst()).length; ++i) {
            boolean isLastRegion;
            byte[] startKey = ((byte[][])keys.getFirst())[i];
            byte[] endKey = ((byte[][])keys.getSecond())[i];
            String regionLocation = this.table.getRegionLocator().getRegionLocation(startKey, false).getHostnamePort();
            if (!this.includeRegionInScan(startKey, endKey)) continue;
            String[] hosts = new String[]{regionLocation};
            boolean bl = isLastRegion = endKey.length == 0;
            if (!scanWithNoLowerBound && !isLastRegion && Bytes.compareTo((byte[])startRow, (byte[])endKey) >= 0 || !scanWithNoUpperBound && Bytes.compareTo((byte[])stopRow, (byte[])startKey) <= 0) continue;
            byte[] splitStart = scanWithNoLowerBound || Bytes.compareTo((byte[])startKey, (byte[])startRow) >= 0 ? startKey : startRow;
            byte[] splitStop = (scanWithNoUpperBound || Bytes.compareTo((byte[])endKey, (byte[])stopRow) <= 0) && !isLastRegion ? endKey : stopRow;
            int id = splits.size();
            TableInputSplit split = new TableInputSplit(id, hosts, this.table.getTableName(), splitStart, splitStop);
            splits.add(split);
        }
        LOG.info("Created " + splits.size() + " splits");
        for (TableInputSplit split : splits) {
            this.logSplitInfo("created", split);
        }
        return splits.toArray(new TableInputSplit[splits.size()]);
    }

    protected boolean includeRegionInScan(byte[] startKey, byte[] endKey) {
        return true;
    }

    public InputSplitAssigner getInputSplitAssigner(TableInputSplit[] inputSplits) {
        return new LocatableInputSplitAssigner((LocatableInputSplit[])inputSplits);
    }

    public BaseStatistics getStatistics(BaseStatistics cachedStatistics) {
        return null;
    }
}

